% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmjmcmc.R
\name{gmjmcmc}
\alias{gmjmcmc}
\title{Main Algorithm for GMJMCMC (Genetically Modified MJMCMC)}
\usage{
gmjmcmc(
  x,
  y,
  transforms,
  P = 10,
  N = 100,
  N.final = NULL,
  probs = NULL,
  params = NULL,
  loglik.pi = NULL,
  loglik.alpha = gaussian.loglik.alpha,
  mlpost_params = list(family = "gaussian", beta_prior = list(type = "g-prior")),
  intercept = TRUE,
  fixed = 0,
  sub = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{matrix containing the design matrix with data to use in the algorithm}

\item{y}{response variable}

\item{transforms}{A character vector including the names of the non-linear functions to be used by the modification and the projection operator.}

\item{P}{The number of population iterations for GMJMCMC. The default value is P = 10, which was used in our initial example for illustrative purposes. However, a larger value, such as P = 50, is typically more appropriate for most practical applications.}

\item{N}{The number of MJMCMC iterations per population.
The default value is N = 100; however, for real applications, a larger value such as N = 1000 or higher is often preferable.}

\item{N.final}{The number of MJMCMC iterations performed for the final population. Per default one has N.final = N, but for practical applications, a much larger value (e.g., N.final = 1000) is recommended. Increasing N.final is particularly important if predictions and inferences are based solely on the last population.}

\item{probs}{A list of various probability vectors used by GMJMCMC, generated by \code{gen.probs.gmjmcmc}.
The key component \code{probs.gen} defines probabilities of different operators in the feature generation process.
Defaults typically favor interactions and modifications (0.4 each) over projections and mutations (0.1 each) to encourage interpretable nonlinear features.}

\item{params}{A list of various parameter vectors used by GMJMCMC, generated by \code{gen.params.gmjmcmc}.}

\item{loglik.pi}{A function specifying the marginal log-posterior of the model up to a constant, including the logarithm of the model prior:
\eqn{\log p(M|Y) = \text{const} + \log p(Y|M) + \log p(M)}.
Typically assumes a Gaussian model with Zellner's with \eqn{g = max(n,p^2) by default}.}

\item{loglik.alpha}{Relevant only if the non-linear projection features depend on parameters \eqn{\alpha}.
If \eqn{\alpha} is estimated, this argument specifies the corresponding marginal log-likelihood.
The default method sets all \eqn{\alpha} to 1 (fastest, but sometimes suboptimal).
Alternative estimation strategies ("deep" and "random") are implemented in \pkg{FBMS}.}

\item{mlpost_params}{All parameters for the estimator function loglik.pi}

\item{intercept}{Logical. Whether to include an intercept in the design matrix. Default is \code{TRUE}. No variable selection is performed on the intercept.}

\item{fixed}{Integer specifying the number of leading columns in the design matrix to always include in the model. Default is 0.}

\item{sub}{Logical. If \code{TRUE}, uses subsampling or a stochastic approximation approach to the likelihood rather than the full likelihood. Default is \code{FALSE}.}

\item{verbose}{Logical. Whether to print messages during execution. Default is \code{TRUE} for \code{gmjmcmc} and \code{FALSE} for the parallel version.}
}
\value{
A list containing the following elements:
\item{models}{All models per population.}
\item{mc.models}{All models accepted by mjmcmc per population.}
\item{populations}{All features per population.}
\item{marg.probs}{Marginal feature probabilities per population.}
\item{model.probs}{Marginal feature probabilities per population.}
\item{model.probs.idx}{Marginal feature probabilities per population.}
\item{best.margs}{Best marginal model probability per population.}
\item{accept}{Acceptance rate per population.}
\item{accept.tot}{Overall acceptance rate.}
\item{best}{Best marginal model probability throughout the run, represented as the maximum value in \code{unlist(best.margs)}.}
}
\description{
Main Algorithm for GMJMCMC (Genetically Modified MJMCMC)
}
\examples{
result <- gmjmcmc(y = matrix(rnorm(100), 100),
x = matrix(rnorm(600), 100), 
P = 2, 
transform = c("p0", "exp_dbl"))
summary(result)
plot(result)

}
