% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnel.SRR.R
\name{funnel.SRR}
\alias{funnel.SRR}
\title{Funnel plot for SRR (standardized readmission ratios)}
\usage{
funnel.SRR(input.dis, input.prov, target = 1, alphas = c(0.1, 0.05,
  0.01), type = "FE.score", sigma.b = NULL)
}
\arguments{
\item{input.dis}{a \code{data.frame} consisting of discharge-specific inputs and provider ID}

\item{input.prov}{a \code{data.frame} consisting of provider-specific inputs and provider ID}

\item{target}{target standardized readmission ratio (SRR)}

\item{alphas}{numeric vector of alpha levels of interest}

\item{type}{string of length one containing the type of test performed. Currently options
include "score", "exact", "FE.score", "FE.exact", "FERE.score", "FERE.exact"}

\item{sigma.b}{sigma for random effects. Should only have value other than null
if prefix "FERE." specified
in \code{type=} argument}
}
\value{
Returns a \code{ggplot} object. Unless stored in a new object,
will be printed automatically.
}
\description{
\code{funnel.SRR} produces and returns funnel plots for the analysis using discharge-specific
and patient-specific inputs with provider ID. Go to
\href{https://github.com/umich-biostatistics/FEprovideR}{Github} for a tutorial.
}
\examples{
# Name input variables and other parameters
# a small positive number specifying stopping
# criterion of Newton-Raphson algorithm
tol <- 1e-5
Y.char <- 'Y'
prov.char <- 'prov.ID'
Z.char <- paste0('z', 1:3)
data(hospital_prepared) # build in data set
fe.ls <- fe.prov(hospital_prepared, Y.char, Z.char, prov.char, tol) # model fitting


# Hypothesis tests
null = "median"
alpha <- 0.05             # significance level
score.fe <- test.fe.prov(hospital_prepared, fe.ls, Y.char,
                         Z.char, prov.char, test="score", null, alpha)

# format input data for funnel plot
input.dis <- data.frame(ID=hospital_prepared[hospital_prepared$included==1, prov.char],
                        prob=fe.ls$Exp)
input.prov <- data.frame(SRR=fe.ls$df.prov$SRR, flag=score.fe$flag)

# render funnel plot
target <- c(1)
alphas = c(0.1, 0.05, 0.01)
funnel.SRR(input.dis, input.prov, target, alphas, type="FE.score")

}
\references{
He, K., Kalbfleisch, J.D., Li, Y. and Li, Y., 2013. Evaluating hospital
readmission rates in dialysis facilities; adjusting for hospital effects. Lifetime data
analysis, 19(4), pp.490-512.
}
\seealso{
\code{\link{fe.data.prep}},  \code{\link{fe.prov}},   \code{\link{test.fe.prov}},
\code{\link{confint.fe.prov}}, \code{ggplot2}
}
