% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spClipPoly.R
\name{spClipPoly}
\alias{spClipPoly}
\title{Spatial - Clip (intersect) polygon vector layer with polygon vector layer.}
\usage{
spClipPoly(
  polyv,
  polyv_dsn = NULL,
  clippolyv,
  clippolyv_dsn = NULL,
  clippolyv.filter = NULL,
  buffdist = NULL,
  validate = FALSE,
  showext = FALSE,
  areacalc = FALSE,
  areaunits = "ACRES",
  nolonglat = TRUE,
  exportsp = FALSE,
  savedata_opts = NULL
)
}
\arguments{
\item{polyv}{sf R object or String. Polygon data to clip. Can be a spatial
polygon object, full pathname to a shapefile, or name of a layer within a
database.}

\item{polyv_dsn}{String. Data source name (dsn; e.g., sqlite or shapefile
pathname) of layer to clip. The dsn varies by driver. See gdal OGR vector
formats (https://www.gdal.org/ogr_formats.html). Optional if polyv is sf
object.}

\item{clippolyv}{SpatialPolygons class R object or String. Name of the
polygon spatial layer to use for clipping.}

\item{clippolyv_dsn}{String. Data source name (dsn; i.e., pathname or
database name) of clippolyv_layer. The dsn varies by driver. See gdal OGR
vector formats (https://www.gdal.org/ogr_formats.html). Optional if
clippolyv_layer is an R object.}

\item{clippolyv.filter}{String. Filter to subset clippolyv spatial layer.}

\item{buffdist}{Number. The distance to buffer the polygon before clipping.
Uses sf::st_buffer. The distance is based on units of polygon, st_crs(x)$units.}

\item{validate}{Logical. If TRUE, validates polyv and clippolyv before 
clipping. Uses sf::st_make_valid with default parameters 
(geos_method='valid_structure', geos_keep_collapsed=FALSE).}

\item{showext}{Logical. If TRUE, layer extents are displayed in plot window.}

\item{areacalc}{Logical. If TRUE, calculate area of clipped polygons and
append to attribute table (See details).}

\item{areaunits}{String. If TRUE, calculate area of clipped polygons and
append to attribute table ("ACRES", "HECTARES", "SQKM"). If NULL, units of
polyv.}

\item{nolonglat}{Logical. If TRUE, and both layer's coordinate system is
long/lat, the layers are converted to a projected CRS before clipping.}

\item{exportsp}{Logical. If TRUE, the spatial clipped object is exported to
outfolder (see spExportSpatial for details).}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options for saving data. If out_layer = NULL, default = 'polyclip'.}
}
\value{
sf object of clipped polygon. If polyv and clippolyv have different
projections, the projection of returned object will have the same projection
as polyv (See note about on-the-fly projection conversion).

If exportsp=TRUE, the sf object will be written to outfolder (See note).
}
\description{
Wrapper for sf::st_intersection, to clip (intersect) polygon vector layer
with another polygon vector layer.
}
\details{
The sf::st_intersection function is used to clip polygons. \cr

areacalc\cr If areacalc = TRUE and the clipped spatial object is not in a
projected coordinate system (i.e., longlat), the object will be reprojected
to the Albers Equal Area projection before area is calculated.
}
\note{
On-the-fly projection conversion\cr The spTransform (sf) method is used
for on-the-fly map projection conversion and datum transformation using
PROJ.4 arguments. Datum transformation only occurs if the +datum tag is
present in the both the from and to PROJ.4 strings. The +towgs84 tag is used
when no datum transformation is needed. PROJ.4 transformations assume NAD83
and WGS84 are identical unless other transformation parameters are
specified.  Be aware, providing inaccurate or incomplete CRS information may
lead to erroneous data shifts when reprojecting. See spTransform help
documentation for more details.

ESRI Shapefile Driver\cr 
If exportsp=TRUE:\cr 
The st_write (sf) function is called. If out_fmt="shp", the ESRI Shapefile 
driver truncates variable names to 10 characters or less. Variable names are 
changed before export using an internal function (trunc10shp). If sf object 
has more than 1 record, it will be returned but not exported.
}
\examples{
\dontrun{
# Set up data from FIESTA
WYbhfn <- system.file("extdata", "sp_data/WYbighorn_adminbnd.shp",
                                    package = "FIESTA"))

# Clip polygon with WY Bighorn object from FIESTA
WYbhco <- spClipPoly(polyv = stunitco,
                     clippolyv = WYbhfn)     
}
}
\author{
Tracey S. Frescino
}
\keyword{data}
