% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spMakeSpatial_options.R
\name{spMakeSpatial_options}
\alias{spMakeSpatial_options}
\title{Make SpatialPoints options}
\usage{
spMakeSpatial_options(
  xvar = NULL,
  yvar = NULL,
  xy.crs = 4269,
  prj = NULL,
  datum = NULL,
  zone = NULL,
  zoneS = FALSE,
  aea.param = "USGS",
  ...
)
}
\arguments{
\item{xvar}{String. Name of variable in xyplt defining x coordinate.}

\item{yvar}{String. Name of variable in xyplt defining y coordinate.}

\item{xy.crs}{PROJ.4 String or CRS object or Integer EPSG code defining
Coordinate Reference System. (e.g., EPSG:4269-Geodetic coordinate system for
North America, NAD83).}

\item{prj}{String. Projection, or coordinate system of the X/Y coordinates
("longlat", "utm", "aea"). If other, include PROJ.4 string in prj4str.}

\item{datum}{String. Datum of projection ("WGS84", "NAD83", "NAD27").}

\item{zone}{Integer. If prj="utm", the UTM zone.}

\item{zoneS}{Logical. If prj="utm", if the UTM zone is in the Southern
hemisphere.}

\item{aea.param}{String. If prj="aea", the associated lat/lon parameters
(USGS: " +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +x_0=0 +y_0=0").  If
other, include PROJ.4 string in prj4str.}

\item{...}{For extendibility.}
}
\value{
A list of user-supplied parameters and parameter values for strata.
}
\description{
Returns a list of user-supplied parameters and parameter values for making
SpatialPoints.
}
\details{
If no parameters, an empty list is returned.
}
\examples{

spMakeSpatial_options()

}
\author{
Grayson W. White
}
\keyword{options}
