#' Fine-Level Structure Simulator
#'
#' A population genetic simulator, which is able to generate synthetic datasets
#' for single-nucleotide polymorphisms (SNP) for multiple populations. The
#' genetic distances among populations can be set according to the Fixation
#' Index (Fst). This tool is able to simulate outlying individuals and missing
#' SNPs can be specified. For Genome-wide association study (GWAS), disease
#' status can be set in desired level according risk ratio.
#'
#' The R package \pkg{FILEST} requires \pkg{KRIS} and \pkg{rARPACK}.
#'
#' Here is the list of functions in the R package \pkg{FILEST}:
#' \itemize{
#' \item \code{\link{cbind_bigmatrix}}
#' \item \code{\link{create.template.setting}}
#' \item \code{\link{demo.filest}}
#' \item \code{\link{filest}}
#' \item \code{\link{rbind_bigmatrix}}
#' }
#'
#' @keywords internal
#' @import rARPACK
#' @import KRIS
"_PACKAGE"
#> [1] "_PACKAGE"

NULL
