% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsetc.R
\name{generate_multivariate_normal_sample}
\alias{generate_multivariate_normal_sample}
\title{It generates a sample from a multivariate normal distribution function}
\usage{
generate_multivariate_normal_sample(p, q, n)
}
\arguments{
\item{p}{Number of desired variables in the dataset X.}

\item{q}{Number of desired variables in the dataset Y.}

\item{n}{sample size desired.}
}
\value{
A list of n sample units with the values for the variables of the data sets X and Y.
}
\description{
It generates a sample from a multivariate normal distribution
function with the cross-covariance matrix described in [Cruz-Cano et al. 2012].
}
\examples{
p<-10
q<-10
n<-50
res<-generate_multivariate_normal_sample(p,q,n)
X<-res$X
Y<-res$Y
rownames(X)<-c(1:n)
colnames(X)<-c(1:p)
colnames(Y)<- c(1:q)
my_res<-frcc(X,Y)
}
\references{
Cruz-Cano, R.; Lee, M.L.T.; Fast Regularized Canonical Correlation Analysis,
Computational Statistics & Data Analysis, Volume 70, 2014, Pages 88-100,
ISSN 0167-9473, https://doi.org/10.1016/j.csda.2013.09.020.
}
\author{
Raul Cruz-Cano
}
