% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_assessment.R
\name{tasmd_rand}
\alias{tasmd_rand}
\title{Target Absolute Standardized Mean Differences (TASMD)}
\usage{
tasmd_rand(
  data_frame,
  index_col = FALSE,
  alloc1,
  alloc2,
  treat_lab = 1,
  legend = c("CRD", "FSM"),
  mean_tar = NULL,
  sd_tar = NULL,
  denom = "target",
  roundoff = 3
)
}
\arguments{
\item{data_frame}{Data frame containing a column of unit indices (optional) and covariates 
(or transformations thereof).}

\item{index_col}{if \code{TRUE}, \code{data_frame} contains a column of unit indices.}

\item{alloc1}{A matrix or vector of treatment assignments. If \code{alloc1} is a matrix, then each row
should correspond to an assignment vector.}

\item{alloc2}{A (optional) matrix or vector of treatment assignment. If \code{alloc2} is a matrix, then each row
should correspond to an assignment vector.}

\item{treat_lab}{Label of the treatment group in which the TASMD is computed.}

\item{legend}{Legend of the two designs under consideration.}

\item{mean_tar}{A (optional) vector of target profile of the covariates under consideration, 
e.g., mean of the covariates in the target population. Applicable only when \code{imbalance = 'TASMD'}. 
If \code{mean_tar = NULL}, the full-sample average of the covariates is considered as the target profile.}

\item{sd_tar}{A optional vector of the standard deviation of the covariates in the target population. 
Applicable only when \code{imbalance = 'TASMD'}.}

\item{denom}{Specifies the denominator for the computation of TASMD. If \code{denom = 'target'}, 
the standard deviations of the covariates in the target population are used. If \code{denom = 'group'}, 
the standard deviations of the covariates in the treatment group given by \code{treat_lab} are used. 
Applicable only when \code{imbalance = 'TASMD'}.}

\item{roundoff}{A number indicating the number of decimal places to be used for rounding off the TASMDs.}
}
\value{
A list containing the following items (if \code{alloc1} and \code{alloc2} are matrices)

\code{tasmd_table}: A matrix containing the means (standard deviations in parenthesis) of the TASMDs
for the designs under consideration. If \code{alloc1} or \code{alloc2} is a vector, the
TASMD of the corresponding assignment is returned.

\code{tasmd_mean}: A matrix containing the means of the TASMDs for the designs under consideration.

\code{tasmd_sd}: A matrix containing the standard deviations of the TASMDs for the designs under consideration.

If \code{alloc1} and \code{alloc2} are vectors, \code{tasmd_rand} produces a data frame of the corresponding TASMDs.
}
\description{
Computes the mean and standard deviation of Target Absolute Standardized Mean Differences (TASMD) of 
multiple covariates (or transformations thereof) in a treatment group relative to a target population 
or a target individual for a set of assignments under one or two designs.
}
\examples{
# Consider the Lalonde dataset.
# Get the full sample size.
N = nrow(Lalonde)
# Get the treatment group sizes.
n1 = floor(N/2)
n2 = N-n1
# Generate an SOM.
som_obs = som(n_treat = 2, treat_sizes = c(n1,n2),include_discard = FALSE,
method = 'SCOMARS', marginal_treat = rep((n2/N),N), control = FALSE)
# Generate a treatment assignment given som_obs.
f = fsm(data_frame = Lalonde, SOM = som_obs, s_function = 'Dopt', eps = 0.0001, 
ties = 'random', intercept = TRUE, standardize = TRUE, units_print = FALSE)
# Get assignment vector under the FSM.
Z_fsm_obs = f$data_frame_allocated$Treat
# Draw a random CRD.
Z_crd_obs = crd(data_frame = Lalonde, n_treat = 2, treat_sizes = c(n1, n2), 
control = FALSE)$Treat
# Calculate the TASMD.
TASMD = tasmd_rand(data_frame = Lalonde, index_col = TRUE, alloc1 = Z_crd_obs, 
alloc2 = Z_fsm_obs, treat_lab = 1, mean_tar = NULL, sd_tar = NULL, 
denom = 'target', legend = c('CRD','FSM'), roundoff = 3)
}
\references{
Chattopadhyay, A., Morris, C. N., and Zubizarreta, J. R. (2020), ``Randomized and Balanced Allocation 
of Units into Treatment Groups Using the Finite Selection Model for \code{R}".
}
\author{
Ambarish Chattopadhyay, Carl N. Morris and Jose R. Zubizarreta.
}
