% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postregression_functions.R
\name{cjoint_plot}
\alias{cjoint_plot}
\title{Plot a FactorHet object}
\usage{
cjoint_plot(object, baseline = NA, plot = TRUE)
}
\arguments{
\item{object}{An object from \code{\link{FactorHet}} or \code{\link{FactorHet_mbo}}.}

\item{baseline}{A specification of baseline levels of each factor. The
default is \code{NA} and shows all coefficients. The documentation for
\code{\link{AME}} discusses how a named list could be provided to show the
difference between coefficients.}

\item{plot}{A logical value as to whether the function should print the plot
immediately or quietly provide an object containing the plot and data. The
default is \code{TRUE}.}
}
\value{
Returns a named list with the underlying data (\code{"data"}) and the
  plot (\code{"plot"}).
}
\description{
Plots the coefficients \eqn{\beta_k} from a fitted FactorHet object for the
main effects only. Use \code{\link{AME}} to calculate average marginal effects. This
provides a fast method to examine the impact of a factor.
}
\examples{
# Fit with one group and limited regularization for example only
# Ignore conjoint structure for simplicity
fit <- FactorHet(Chosen_Immigrant ~ Plans + Ed + Country,
  design = immigration, lambda = 1e-2,
  K = 1, group = ~ CaseID, task = ~ contest_no, choice_order = ~ choice_id)
# Plot the raw coefficients
cjoint_plot(fit)

}
\seealso{
\link{AME}
}
