% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logis.R
\name{logis}
\alias{logis}
\title{The logistic transform}
\usage{
logis(Y,param)
}
\arguments{
\item{Y}{A generic matrix or one dimensional array}

\item{param}{Vector of coefficients, whose length is NCOL(Y) + 1 (to consider also an intercept term)}
}
\value{
Return a vector whose length is NROW(Y) and whose i-th component is the logistic function
at the scalar product between the i-th row of YY and the vector \code{param}.
}
\description{
Create a matrix YY binding array \code{Y} with a vector of ones, placed as the first column of YY.
It applies the logistic transform componentwise to the standard matrix multiplication between YY and \code{param}.
}
\examples{
n<-50 
Y<-sample(c(1,2,3),n,replace=TRUE) 
param<-c(0.2,0.7)
logis(Y,param)
}
\keyword{utilities}
