% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higherOrderFunctions.R
\name{createMutator}
\alias{createMutator}
\title{Create a Mutator Function}
\usage{
createMutator(binaryOperator)
}
\arguments{
\item{binaryOperator}{A binary operator function to apply for the mutation.}
}
\value{
A function that takes a variable and a value, applying the binary
operator to update the variable in the parent frame.
}
\description{
Creates a mutator function based on a specified binary operator.
The output mutator function updates a variable in the parent frame by
applying the binary operator with a given value. It's recommended to use
this function to easily construct special functions in the form of \verb{\%f\%}
where \code{f} can be any symbol of choice. See examples.
}
\examples{
"\%+=\%" <- createMutator(add)
x <- 1
x \%+=\% 1
x # becomes 2

}
\keyword{higherOrderFunctions}
