% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedirt_2PL.R
\name{mem}
\alias{mem}
\title{Memoization Function for Speed Optimization}
\usage{
mem(f)
}
\arguments{
\item{f}{Function to be memd.}
}
\value{
Returns a memd version of function \code{f} that will cache its previously computed results for faster subsequent evaluations, especially beneficial when applied to \code{fedirt}.
}
\description{
A simple memoization function that stores the results of expensive function calls and reuses those results when the same inputs occur again. This technique greatly speeds up the computation of \code{fedirt} function by caching previously computed values.
}
\examples{
# To mem a function, simply wrap it with `mem`:
mem(function(a,b){return(a+b)})
}
