% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSmdFWER.R
\name{FSmdFWER.arbidept.cv}
\alias{FSmdFWER.arbidept.cv}
\title{Critical values for Fixed Sequence mdFWER Controlling Procedure under Arbitrary Dependence Along with Directional Decisions Regarding Parameters of Interest}
\usage{
FSmdFWER.arbidept.cv(p, test.stat, alpha=0.05, make.decision = TRUE)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{test.stat}{numeric vector of test statistics, which are used to determine the direction of decisions, with the same length of \code{p}.}

\item{alpha}{significant level used to compare with Critical values to make decisions, the default value is 0.05.}

\item{make.decision}{logical; if \code{TRUE} (default), then the output include the decision rules compared original p-values with the critical values, and directions of the decision based on the sign of test statistics.}
}
\value{
A numeric vector of the critical values (of the same length as \code{p}) if  \code{make.decision = FALSEALSE}, or a data frame including original p-values, critical values, test statistics and directional decision rules if \code{make.decision = TRUE}.
}
\description{
Given a set of pre-ordered test statistics and the corresponding p-values, returns critical values using the directional fixed sequence multiple testing procedures under arbitrary dependence (See Procedure 1 and Theorem 1 in Grandhi et al. (2016)). The function also provides an option to make decisions and determine the sign given a pre-specified significant level \eqn{\alpha} and the test statistics.
}
\examples{
## Clinical trial example in Grandhi et al. (2016)
Pval <- c(0.0008, 0.0135, 0.0197, 0.7237, 0.0003, 0.2779, 0.0054, 0.8473)
Zstat <- c(3.4434, 2.5085, 2.3642, -0.3543, 3.7651, 1.0900, 2.8340, 0.1930)
FSmdFWER.arbidept.cv(p = Pval, test.stat = Zstat, make.decision = TRUE)
}
\author{
Yalin Zhu
}
\references{
Grandhi, A., Guo, W., & Romano, J. P. (2016).
 Control of Directional Errors in Fixed Sequence Multiple Testing.
 \emph{arXiv preprint} arXiv:1602.02345.
}
\seealso{
\code{\link{FSmdFWER.indept.cv}} for fixed sequence mdFWER controlling procedures under independence.
}

