% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDinterfaces.R
\name{FD.amalgamation}
\alias{FD.amalgamation}
\title{Amalgamation}
\usage{
FD.amalgamation(data, columns, name = NULL)
}
\arguments{
\item{data}{a matrix or a dataframe containing only variables to be transformed into compositional variables, after amalgamation.}

\item{columns}{numeric vector containing the position of the columns to be amalgamated together.}

\item{name}{string containing the name of the new column resulted from the amalgamation.}
}
\description{
Given a matrix or a numeric dataframe, this function returns a composition where a set of specified columns is amalgamated together.
The compositional operation of amalgamation  provides sums of composition elements aimed at grouping homogeneous parts of the whole.
}
\details{
Values must be positive. In case one row-entry (or more) is NA, the whole row will be returned as NA.
}
\examples{
data(oliveoil)
dataoil <- oliveoil
head(dataoil)
data <- FD.normalization(dataoil[,3:10])
head(data)
data.sub <- FD.subcomposition(data,c(1,3,4,5))
head(data.sub)
data.amalg <- FD.amalgamation(data,c(2,6,7,8),name='others')
head(data.amalg)

}
\seealso{
\code{\link{FD.generate}}, \code{\link{FD.subcomposition}}, \code{\link{FD.normalization}}
}
