% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDinterfaces.R
\name{FD.theorcontours}
\alias{FD.theorcontours}
\title{Contour Lines of a Flexible Dirichlet}
\usage{
FD.theorcontours(a, p, t, type = "ternary", var = c(1, 2), zoomed = T,
  showgrid = T, nlevels = 10)
}
\arguments{
\item{a}{vector of the non-negative alpha parameters.}

\item{p}{vector of the clusters' probabilities. It must sum to one.}

\item{t}{non-negative scalar tau parameter.}

\item{type}{string indicating whether to plot the contour lines on a ternary diagram \code{'ternary'}, or on a right triangle plot \code{'right'}.}

\item{var}{numeric vector containing the two variables to be plotted on the axis. Used only if \code{type='right'}.}

\item{zoomed}{if \code{TRUE}, shows only the area where most of the density is concentrated. If \code{FALSE}, shows the whole area.}

\item{showgrid}{if \code{TRUE}, shows the axis and the labels. If \code{FALSE}, only the graph is printed.}

\item{nlevels}{approximate number of contour lines to be drawn.}
}
\description{
Contour lines of a Flexible Dirichlet with given parameters on the ternary diagram or on the right triangle.
}
\details{
The number of variables in the Flexible Dirichlet must be 3 to draw a plot. Vectors \code{a} and \code{p} must be of the same length.
}
\examples{
alpha <- c(12,7,15)
prob <- c(0.3,0.4,0.3)
tau <- 8
FD.theorcontours(alpha,prob,tau)
FD.theorcontours(alpha,prob,tau, type='right', var=c(3,2), zoomed=FALSE, showgrid=TRUE, nlevels=3)

}
\references{
{
 Ongaro, A. and Migliorati, S. (2013) A generalization of the Dirichlet distribution. Journal of Multivariate Analysis, \bold{114}, 412--426.\cr
\cr
 Migliorati, S., Ongaro, A. and Monti, G. S. (2016) A structured Dirichlet mixture model for compositional data: inferential and applicative issues. Statistics and Computing, doi:10.1007/s11222-016-9665-y.
}
}
\seealso{
\code{\link{FD.generate}}, \code{\link{FD.density}}
}
