% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateErrors.R
\name{estimateErrors}
\alias{estimateErrors}
\title{Estimate Errors in 'PLINK'' ped files}
\usage{
estimateErrors(
  file,
  outdir = NA,
  db = NA,
  appendSamplesToDB = FALSE,
  keep.rep = 1,
  y.marker = NA,
  x.marker = NA,
  sp.marker = NA,
  plots = TRUE,
  neg_controls = NA,
  allele_error = 5,
  marker_dropout = 15,
  no_marker = 50,
  male.y = 3,
  male.hetX = 0,
  female.y = 0,
  female.Xtot = 8,
  female.hetXtot = 3,
  warning.noYtot = 2,
  warning.noHetXtot = 3,
  sexing = FALSE,
  verbose = TRUE,
  verbosity = 1
)
}
\arguments{
\item{file}{A string. Path to the ped input file.}

\item{outdir}{A string specifying the output folder. If left empty the original folder path of the input file will be used.}

\item{db}{A string. Name of the used database. Default is NA.}

\item{appendSamplesToDB}{A logical. Should new samples be added to database? Default is FALSE.}

\item{keep.rep}{A numeric. Keep only this n-fold replicates, default n=1.}

\item{y.marker}{A vector. Y markers for sexing. Default is NA.}

\item{x.marker}{A vector. X markers for sexing. Default is NA.}

\item{sp.marker}{A vector. Markers used for species-identification. Default is NA.}

\item{plots}{A logical. Should plots be created? Default is TRUE.}

\item{neg_controls}{A vector. Names of negative controls. Default is NA.}

\item{allele_error}{A numeric. Threshold for RERUN on Allele errors. Default is 5.}

\item{marker_dropout}{A numeric. Threshold for RERUN on Marker dropout. Default is 15.}

\item{no_marker}{A numeric. Number of markers. Default is 50.}

\item{male.y}{A numeric. Threshold for sexing, male y-chromosome markers. Default is 3.}

\item{male.hetX}{A numeric. Threshold for sexing, heterozygote x-chr markers. Default is 0.}

\item{female.y}{A numeric. Threshold for sexing, female y-chromosome markers. Default is 0.}

\item{female.Xtot}{A numeric. Threshold for sexing, total female x-chr markers. Default is 8.}

\item{female.hetXtot}{A numeric. Threshold for sexing, heterozygote x-chr markers. Default is 3.}

\item{warning.noYtot}{A numeric. Threshold for sexing, when should warning be triggered. Default is 2.}

\item{warning.noHetXtot}{A numeric. Threshold for sexing, when should warning be triggered. Default is 3.}

\item{sexing}{A logical. Should sexing be performed? Default is FALSE.}

\item{verbose}{A logical or numeric. Should the output be verbose? Default is TRUE.}

\item{verbosity}{A numeric. Level of verbosity, set to higher number for more details. Default is 1.}
}
\value{
A list containing the following elements:
gensim, a matrix indicating if genotypes are called correctly for replicates and/or if genotypes are missing
summs, a matrix with summary statistics
}
\description{
This function processes the 'PLINK' ped files and estimates errors. It also performs sex assignment and species marker analysis if required.
}
\details{
This function processes the PLINK ped files and estimates errors. It checks if the first and second run of each sample have the same genotype and if both
replicates are identical. It also performs sex assignment based on the provided Y and X markers. If species marker is provided, it performs species marker
analysis. The function creates a consensus PED for all "GOOD" samples and exports it along with a .map file without the Y-markers. It also creates a
database file, if provided.
}
\examples{
\dontrun{
    # outdir is here the output directory from the fluidigm2PLINK function

    # Estimate the errors with sexing applied
    estimateErrors(file=file.path(outdir, "example_data.csv.ped"),
                   keep.rep = 2)

    # Estimate the errors and apply sexing with y and x markers defined
    estimateErrors(file=file.path(outdir, "example_data.csv.ped"),
                   keep.rep = 2,
                   sexing=TRUE,
                   y.marker = c("Y_scaffoldY158711_762",
                                "Y_scaffoldY42647_3017",
                                "Y_scaffoldY42656_3986"),
                   x.marker = c("X_scaffold11905_7659",
                                "X_scaffold17088_4621",
                                "X_scaffold1915_14108",
                                "X_scaffold4825_648",
                                "X_scaffold5374_1437",
                                "X_scaffold10171:3154"))
}
}
