% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{cttools}
\alias{cttools}
\title{Cross-temporal reconciliation tools}
\usage{
cttools(agg_mat, cons_mat, agg_order, tew = "sum", fh = 1, sparse = TRUE)
}
\arguments{
\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{cons_mat}{A (\eqn{n_a \times n}) numeric matrix representing the cross-sectional
zero constraints: each row represents a constraint equation, and each column represents
a variable. The matrix can be of full rank, meaning the rows are linearly independent,
but this is not a strict requirement, as the function allows for redundancy in the
constraints.}

\item{agg_order}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \eqn{m}), or a vector representing a subset of \eqn{p} factors
of \eqn{m}.}

\item{tew}{A string specifying the type of temporal aggregation. Options include:
"\code{sum}" (simple summation, \emph{default}), "\code{avg}" (average),
"\code{first}" (first value of the period), and "\code{last}"
(last value of the period).}

\item{fh}{Forecast horizon for the lowest frequency (most temporally aggregated)
time series (\emph{default} is \code{1}).}

\item{sparse}{Option to return sparse matrices (\emph{default} is \code{TRUE}).}
}
\value{
A list with four elements:
\item{dim}{A vector containing information about the number of series for the
complete system (\code{n}), for upper levels (\code{na}) and bottom level
(\code{nb}), the maximum aggregation order  (\code{m}), the number of factor
(\code{p}), the partial (\code{ks}) and total sum (\code{kt}) of factors.}
\item{set}{The vector of the temporal aggregation orders (in decreasing order).}
\item{agg_mat}{The cross-temporal aggregation matrix.}
\item{strc_mat}{The cross-temporal structural matrix.}
\item{cons_mat}{The cross-temporal zero constraints matrix.}
}
\description{
Some useful tools for the cross-temporal forecast reconciliation of a linearly constrained
(e.g., hierarchical/grouped) multiple time series.
}
\examples{
# Cross-temporal framework
A <- t(c(1,1)) # Aggregation matrix for Z = X + Y
m <- 4 # from quarterly to annual temporal aggregation
cttools(agg_mat = A, agg_order = m)

}
\seealso{
Cross-temporal framework: 
\code{\link{ctboot}()},
\code{\link{ctbu}()},
\code{\link{ctcov}()},
\code{\link{ctlcc}()},
\code{\link{ctmo}()},
\code{\link{ctrec}()},
\code{\link{cttd}()},
\code{\link{iterec}()},
\code{\link{tcsrec}()}

Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{set_bounds}()},
\code{\link{shrink_estim}()},
\code{\link{shrink_oasd}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Framework: cross-temporal}
\concept{Utilities}
