% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v_red_harvest_ubark.R
\name{v_red_harvest_ubark}
\alias{v_red_harvest_ubark}
\title{Reduce a Given standing Volume Over Bark to Harvested Volume Under Bark}
\usage{
v_red_harvest_ubark(species_id, v_orig_m3)
}
\arguments{
\item{species_id}{Vector of species id's. Ideally, these species_id's are
provided as a \code{\link{fe_species_tum_wwk_short}} or a
\code{\link{fe_species_bavrn_state_short}} object. If they are provided as
another \code{fe_species} object, \code{v_red_harvest_ubark} will make an
attempt to convert them into \code{\link{fe_species_tum_wwk_short}}. The
exception is the coding \code{\link{fe_species_bavrn_state}} which will be
converted into \code{\link{fe_species_bavrn_state_short}}. If all
conversion attempts fail, the function will terminate with an error. The
species id's can also be provided as numeric values (\code{double} or
\code{integer}) or \code{character}. These will be internally converted to
\code{\link{fe_species_tum_wwk_short}}. If this fails (i.e. the user
provided species codes are not defined in the \emph{tum_wwk_short} coding), an
error is thrown and the function terminates.}

\item{v_orig_m3}{Vector of wood volumes (m³) defined as standing over bark.
If \code{species_id} and \code{v_orig_m3} do not have the same length, an
attempt is made to recyle them according to the tibble rules.}
}
\value{
A vector of the reduced volumes defined as harveest
}
\description{
Many tree volume functions (like \code{\link{v_gri}}) calculate wood volumes
defined as standing and over bark. Practictioners often prefer to work with
volumes where the harvest losses and the bark volume have been substracted.
Given an over bark standing volume, this function uses species specific
reduction factors in order to obtain harvested volume under bark. The
reduction factors are taken from
\insertCite{hilfstafeln_bavaria_1990}{ForestElementsR}; they relate to the
species coding \code{fe_species_tum_wwk_short} or, alternatively
\code{fe_species_bavrn_state_short}.
}
\examples{
  # Take all species groups of tum_wwk_short and a standing volume of 1 m³
  # over bark
  species_id <- fe_species_tum_wwk_short(1:10)
  v_red_harvest_ubark(species_id, 1)

}
\references{
\insertAllCited{}
}
