% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FracKrig.R
\name{FracKrig}
\alias{FracKrig}
\title{FracKrig}
\usage{
FracKrig(X, Z, Xnew, H)
}
\arguments{
\item{X}{Coordinates}

\item{Z}{observations}

\item{Xnew}{Coordinates of points where the prognosis should be made}

\item{H}{Hurst parameter (a real in interval [0,1))}
}
\value{
Returns a matrix of fractional kriging prognosis.
}
\description{
Performs extrapolation for spatial multivariate data
}
\examples{

library(sp)
library(gstat)
 data(meuse)
 xy<-cbind(meuse$x,meuse$y)
 X<-xy[1:50,]
 min_max_norm <- function(x) {
     (x - min(x)) / (max(x) - min(x))
 }
 normalize <- function(x) {
 return ((x - min(x)) / (max(x) - min(x)))
 }
 dat<-cbind(meuse[3],meuse[4],meuse[5])
 data<-dat[51:100,]
 zz1 <- as.data.frame(lapply(dat, normalize))
 data1=as.data.frame(lapply(as.data.frame(data), normalize))
 Z<-as.matrix(zz1[1:50,])
library(FracKrigingR)
 K<-50
#Hurst parameter estimation
 H<-0.2
 Xnew<-xy[51:100,]
 results<- FracKrig(X,Z,Xnew,H)
 denormalize <- function(x, bottom, top){
    (top - bottom) * x + bottom
 }
z1 = denormalize(
 results[,1], top = max(data[,1]), bottom = min(data[,1])
)
z2 = denormalize(
results[,2], top = max(data[,2]), bottom = min(data[,2])
)
z3 = denormalize(
 results[,3], top = max(data[,3]), bottom = min(data[,3])
)
RMSE<-function(z,prognosis){
 rmse<-sqrt(((1/(length(z))))*sum((z-prognosis)^2))
 rmse
}
Cd<-RMSE(data[,1],z1)
Cu<-RMSE(data[,2],z2)
Pb<-RMSE(data[,3],z3)
Cd
Cu
Pb

}
