% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLCDF.R
\name{MLCDF}
\alias{MLCDF}
\title{Multinomial logistic calibration estimator under dual frame approach with auxiliary information from each frame}
\usage{
MLCDF (ysA, ysB, pik_A, pik_B, domains_A, domains_B, xsA, xsB, xA, xB, ind_samA, 
 ind_samB, ind_domA, ind_domB, N, N_ab = NULL, met = "linear", conf_level = NULL)
}
\arguments{
\item{ysA}{A data frame containing information about one or more factors, each one of dimension \eqn{n_A}, collected from \eqn{s_A}.}

\item{ysB}{A data frame containing information about one or more factors, each one of dimension \eqn{n_B}, collected from \eqn{s_B}.}

\item{pik_A}{A numeric vector of length \eqn{n_A} containing first order inclusion probabilities for units included in \eqn{s_A}.}

\item{pik_B}{A numeric vector of length \eqn{n_B} containing first order inclusion probabilities for units included in \eqn{s_B}.}

\item{domains_A}{A character vector of size \eqn{n_A} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "a" and "ab".}

\item{domains_B}{A character vector of size \eqn{n_B} indicating the domain each unit from \eqn{s_B} belongs to. Possible values are "b" and "ba".}

\item{xsA}{A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, containing auxiliary information in frame A for units included in \eqn{s_A}.}

\item{xsB}{A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, containing auxiliary information in frame B for units included in \eqn{s_B}.}

\item{xA}{A numeric vector or length \eqn{N_A} or a numeric matrix or data frame of dimensions \eqn{N_A} x \eqn{m_A}, with \eqn{m_A} the number of auxiliary variables in frame A, containing auxiliary information for the units in frame A.}

\item{xB}{A numeric vector or length \eqn{N_B} or a numeric matrix or data frame of dimensions \eqn{N_B} x \eqn{m_B}, with \eqn{m_B} the number of auxiliary variables in frame B, containing auxiliary information for the units in frame B.}

\item{ind_samA}{A numeric vector of length \eqn{n_A} containing the identificators of units of the frame A (from 1 to \eqn{N_A}) that belongs to \eqn{s_A}.}

\item{ind_samB}{A numeric vector of length \eqn{n_B} containing the identificators of units of the frame B (from 1 to \eqn{N_B}) that belongs to \eqn{s_B}.}

\item{ind_domA}{A character vector of length \eqn{N_A} indicating the domain each unit from frame A belongs to. Possible values are "a" and "ab".}

\item{ind_domB}{A character vector of length \eqn{N_B} indicating the domain each unit from frame B belongs to. Possible values are "b" and "ba".}

\item{N}{A numeric value indicating the size of the population.}

\item{N_ab}{(Optional) A numeric value indicating the size of the overlap domain}

\item{met}{(Optional) A character vector indicating the distance that must be used in calibration process. Possible values are "linear", "raking" and "logit". Default is "linear".}

\item{conf_level}{(Optional) A numeric value indicating the confidence level for the confidence intervals, if desired.}
}
\value{
\code{MLCDF} returns an object of class "MultEstimatorDF" which is a list with, at least, the following components:
 \item{Call}{the matched call.}
 \item{Est}{class frequencies and proportions estimations for main variable(s).}
}
\description{
Produces estimates for class totals and proportions using multinomial logistic regression from survey data obtained
 from a dual frame sampling design using a model calibrated dual frame approach with a possibly different set of auxiliary variables for each frame.
 Confidence intervals are also computed, if required.
}
\details{
Multinomial logistic calibration estimator in dual frame using auxiliary information from each frame for a proportion is given by
 \deqn{\hat{P}_{MLCi}^{DF} = \frac{1}{N} \left(\sum_{k \in s_A \cup s_B} w_k^{\circ} z_{ki}\right), \hspace{0.3cm} i = 1,...,m}
 with \eqn{m} the number of categories of the response variable, \eqn{z_i} the indicator variable for the i-th category of the response variable,
 and \eqn{w^{\circ}} calibration weights which are calculated having into account a different set of constraints, depending on the case. For instance, if \eqn{N_A, N_B} and \eqn{N_{ab}} are known, calibration constraints are
 \deqn{\sum_{k \in s_a}w_k^{\circ} = N_a, \sum_{k \in s_{ab}}w_k^{\circ} = \eta N_{ab}, \sum_{k \in s_{ba}}w_k^{\circ} = (1 - \eta) N_{ab}\sum_{k \in s_{b}}w_k^{\circ} = N_{b},} \deqn{\sum_{k \in s_A}w_k^\circ p_{ki}^A = \sum_{k \in U_a} p_{ki}^A + \eta \sum_{k \in U_{ab}} p_{ki}^A}
 and \deqn{\sum_{k \in s_B}w_k^\circ p_{ki}^B = \sum_{k \in U_b} p_{ki}^B + (1 - \eta) \sum_{k \in U_{ba}} p_{ki}^B}
with \eqn{\eta \in (0,1)} and \deqn{p_{ki}^A = \frac{exp(x_k^{'}\beta_i^A)}{\sum_{r=1}^m exp(x_k^{'}\beta_r^A)},}
being \eqn{\beta_i^A} the maximum likelihood parameters of the multinomial logistic model considering original design weights \eqn{d^A}. \eqn{p_{ki}^B} can be defined similarly.
}
\examples{
data(DatMA)
data(DatMB)
data(DatPopM) 

N <- nrow(DatPopM)
levels(DatPopM$Domain) <- c(levels(DatPopM$Domain), "ba")
DatPopMA <- subset(DatPopM, DatPopM$Domain == "a" | DatPopM$Domain == "ab", stringAsFactors = FALSE)
DatPopMB <- subset(DatPopM, DatPopM$Domain == "b" | DatPopM$Domain == "ab", stringAsFactors = FALSE)
DatPopMB[DatPopMB$Domain == "ab",]$Domain <- "ba"

#Let calculate proportions of categories of variable Prog using MLCDF estimator
#using Read as auxiliary variable
MLCDF(DatMA$Prog, DatMB$Prog, DatMA$ProbA, DatMB$ProbB, DatMA$Domain, DatMB$Domain, 
DatMA$Read, DatMB$Read, DatPopMA$Read, DatPopMB$Read, DatMA$Id_Frame, DatMB$Id_Frame, 
DatPopMA$Domain, DatPopMB$Domain, N)

#Let obtain 95\% confidence intervals together with the estimations
MLCDF(DatMA$Prog, DatMB$Prog, DatMA$ProbA, DatMB$ProbB, DatMA$Domain, DatMB$Domain, 
DatMA$Read, DatMB$Read, DatPopMA$Read, DatPopMB$Read, DatMA$Id_Frame, DatMB$Id_Frame, 
DatPopMA$Domain, DatPopMB$Domain, N, conf_level = 0.95)
}
\references{
Molina, D., Rueda, M., Arcos, A. and Ranalli, M. G. (2015)
 \emph{Multinomial logistic estimation in dual frame surveys}
 Statistics and Operations Research Transactions (SORT). To be printed.
}
\seealso{
\code{\link{JackMLCDF}}
}

