% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simX.R
\name{simX}
\alias{simX}
\title{Generate the sequence (genotypes) data containing only 0, 1 and 2}
\usage{
simX(n, m, seed = 1, d.ratio = 0)
}
\arguments{
\item{n}{an interger variable specifying the number of samples to be generated.}

\item{m}{an interger variable specifying the sequence length of each sample.}

\item{seed}{an integer variable specifying the random seed used for random sequence generation.}

\item{d.ratio}{a numeric variable between 0 and 1 indicating the deletion ratio of sample sequences, default value is 0.}
}
\value{
An "simX" object that contains the list of the following items.
\itemize{
\item{location:}{ a numeric vector defining the sampling sites of the sequence data.}
\item{X:}{ a matrix with n rows and m columns representing the sequence data.}
}
}
\description{
This function provides a method for generating sequence data containing only 0, 1 and 2, which can be used to simulate the generation of sequence genotypes.
}
\examples{
library(FunctanSNP)
n <- 2
m <- 50
simdata1 <- simX(n, m, seed = 1, d.ratio = 0)
simdata2 <- simX(n, m, seed = 1, d.ratio = 0.3)
plotRawdata(location = simdata1$location, X = simdata1$X)
plotRawdata(location = simdata2$location, X = simdata2$X)

}
\seealso{
See Also as \code{\link{plotRawdata}}, \code{\link{SNPgvf}}.
}
