% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.random.R
\name{as.random}
\alias{as.random}
\title{Encodes a vector as a "random factor"}
\usage{
as.random(x)
}
\arguments{
\item{x}{a vector of data, usually a nominal variable.}
}
\value{
Function \code{as.random} returns an object of class \code{"factor"} and \code{"random"}.
}
\description{
Assigns a class \code{"random"} to a vector
}
\details{
The function works the same way as \code{\link{as.factor}}, but assigns an additional class informing that it is a random factor.
}
\examples{
library(GAD)
data(rohlf95)
CG <- as.fixed(rohlf95$cages)
MQ <- as.random(rohlf95$mosquito)
class(CG)
class(MQ)
}
\seealso{
\code{\link{as.fixed}}
}
\author{
Leonardo Sandrini-Neto (\email{leonardosandrini@ufpr.br})
}
