% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{ER.test}
\alias{ER.test}
\title{Entropy Ratio test}
\usage{
ER.test(object)
}
\arguments{
\item{object}{fitted \code{\link{lmgce}} object.}
}
\value{
A matrix with the X-squared statistics, degrees of freedom and
p-value for each parameter.
}
\description{
The Entropy Ratio test - which corresponds to the likelihood ratio, or
empirical ratio, test - measures the entropy discrepancy between the
constrained and the unconstrained models.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}

ER.test(res_gce_package)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
