% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changestep.R
\name{changestep}
\alias{changestep}
\title{Change the step from \code{\link{lmgce}} object}
\usage{
changestep(object, twosteps.n, verbose = 0)
}
\arguments{
\item{object}{fitted \code{\link{lmgce}} object.}

\item{twosteps.n}{An integer that defines the number of GCE reestimations to
be used.}

\item{verbose}{An integer to control how verbose the output is. For a value
of 0 no messages or output are shown and for a value of 3 all messages
are shown. The default is \code{verbose = 0}.}
}
\value{
An \code{\link{lmgce}} object with the specified number of GCE
reestimations
}
\description{
Changes the number of GCE reestimations of a \code{\link{lmgce}} object
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        twosteps.n = 10,
        seed = 230676)

res_gce_package_change_step <- changestep(res_gce_package, 5)

summary(res_gce_package)

summary(res_gce_package_change_step)
}

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
