% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsbootgceclassfunctions.R
\name{plot.tsbootgce}
\alias{plot.tsbootgce}
\title{Plot Diagnostics for a \code{\link{tsbootgce}} object}
\usage{
\method{plot}{tsbootgce}(
  x,
  which = c(1, 2),
  group = TRUE,
  group.ncol = NULL,
  group.nrow = NULL,
  ci.levels = c(0.9, 0.95, 0.99),
  ci.method = c("hdr", "basic", "percentile"),
  seed = object$seed,
  lambda = 1,
  col = NULL,
  plot.lines = TRUE,
  legend.position = "bottom",
  ...
)
}
\arguments{
\item{x}{Fitted \code{tsbootgce} object.}

\item{which}{Integers from 1 to 3. The default is \code{which = c(1,2)}.}

\item{group}{Boolean value. If \code{group = TRUE}, the default, plots are
grouped in one image.}

\item{group.ncol}{Number of columns (see \code{\link[ggpubr]{ggarrange}}).
The default is \code{group.ncol = NULL}.}

\item{group.nrow}{Number of rows. (see \code{\link[ggpubr]{ggarrange}}).
The default is \code{group.nrow = NULL}.}

\item{ci.levels}{the confidence levels (maximum of 4) required to compute the
confidence interval. The default is \code{ci.levels = c(0.90, 0.95, 0.99)}.}

\item{ci.method}{One of \code{c("hdr", "basic", "percentile")}. The default
is \code{ci.method = "hdr"} (see \code{\link[hdrcde]{hdr}}).}

\item{seed}{A single value, interpreted as an integer, for reproducibility
or \code{NULL} for randomness. The default is \code{seed = object$seed}.}

\item{lambda}{Box-Cox transformation parameter. Value between 0 and 1. The
default is \code{lambda = 1} (see \code{\link[hdrcde]{hdr}}).}

\item{col}{Vector of colors for regions. The default is \code{col = NULL}.}

\item{plot.lines}{Boolean. The default is \code{plot.lines = TRUE}.}

\item{legend.position}{The default is \code{legend.position = "bottom"}.}

\item{...}{additional arguments.}
}
\value{
A \code{ggplot} object.
}
\description{
Three plots (selectable by \code{which}) are currently available to
evaluate a \code{\link{tsbootgce}} object.
}
\examples{
\donttest{
res.tsbootgce <-
  tsbootgce(
    formula = CO2 ~ 1 + L(GDP, 1) + L(EPC, 1) + L(EU, 1),
    data = moz_ts)

plot(res.tsbootgce, which = 2, group = TRUE)
}

}
\seealso{
\code{\link[GCEstim]{tsbootgce}}
}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
