% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_c130_dbh.R
\name{add_c130_dbh}
\alias{add_c130_dbh}
\title{Add or compute c130 and dbh columns}
\usage{
add_c130_dbh(data, output = NULL)
}
\arguments{
\item{data}{A data frame containing tree measurements.
Must include at least one of the following columns:
\itemize{
\item \code{c130}: circumference at 1.30 m (cm)
\item \code{dbh}: diameter at 1.30 m (cm)
}}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.}
}
\value{
The same data frame with both \code{c130} and \code{dbh} columns.
Note: the function does not modify the input data frame in place.
To update your object, you must reassign the result, e.g.:
\code{data2 <- add_c130_dbh(data2)}
}
\description{
Ensures that both \code{c130} (circumference at 1.30 m) and \code{dbh} (diameter at 1.30 m)
are present in the dataset. If one is missing, it is computed from the other.
}
\details{
\itemize{
\item This function should be used at the very beginning of the workflow
to ensure both \code{c130} and \code{dbh} columns are available for subsequent functions.
\item Conversion uses the formula: \code{dbh = c130 / pi} and \code{c130 = dbh * pi}.
\item Units are centimeters (cm).
\item If both columns are present, values are left unchanged.
}
}
\examples{
data <- data.frame(c130 = c(31.4, 62.8))
data <- add_c130_dbh(data)

data2 <- data.frame(dbh = c(10, 20))
data2 <- add_c130_dbh(data2)

}
