% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{CA}
\alias{CA}
\title{Calculate classification accuracy}
\usage{
CA(GDINA.obj, what = "MAP")
}
\arguments{
\item{GDINA.obj}{estimated GDINA object returned from \code{\link{GDINA}}}

\item{what}{what attribute estimates are used? Default is \code{"MAP"}.}
}
\value{
a list with elements
\describe{
\item{tau}{estimated test-level classification accuracy, see Iaconangelo (2017, Eq 2.2)}
\item{tau_l}{estimated pattern-level classification accuracy, see Iaconangelo (2017, p. 13)}
\item{tau_k}{estimated attribute-level classification accuracy, see Wang, et al (2015, p. 461 Eq 6)}
\item{CCM}{Conditional classification matrix, see Iaconangelo (2017, p. 13)}
}
}
\description{
This function calculates test-, pattern- and attribute-level classification accuracy indices based on GDINA estimates from
the \code{GDINA} function using approaches in Iaconangelo (2017) and Wang, Song, Chen, Meng, and Ding (2015).
It is only applicable for dichotomous attributes.
}
\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ
fit <- GDINA(dat = dat, Q = Q, model = "GDINA")
fit
CA(fit)
}
}
\references{
Iaconangelo, C.(2017). \emph{Uses of Classification Error Probabilities in the Three-Step Approach to Estimating Cognitive Diagnosis Models.} (Unpublished doctoral dissertation). New Brunswick, NJ: Rutgers University.

Ma, W., & de la Torre, J. (2020). GDINA: An R Package for Cognitive Diagnosis Modeling. \emph{Journal of Statistical Software, 93(14)}, 1-26.

Wang, W., Song, L., Chen, P., Meng, Y., & Ding, S. (2015). Attribute-Level and Pattern-Level Classification Consistency and Accuracy Indices for Cognitive Diagnostic Assessment.
\emph{Journal of Educational Measurement, 52} , 457-476.
}
\author{
Wenchao Ma, The University of Minnesota, \email{wma@umn.edu}
}
