% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_audit.R
\name{gg_audit}
\alias{gg_audit}
\title{Comprehensive Audit of ggplot2 Visualization}
\usage{
gg_audit(plot, checks = "all")
}
\arguments{
\item{plot}{A ggplot2 object}

\item{checks}{Character vector of checks to run. Default is "all".
Options: "color", "scales", "text", "accessibility", "labels"}
}
\value{
A list with class "gg_audit_report" containing audit results
}
\description{
Runs all available audit checks on a ggplot2 object and returns
a comprehensive report of potential issues and suggestions.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(wt, mpg, color = factor(cyl))) +
  geom_point() +
  scale_color_manual(values = c("red", "green", "blue"))
report <- gg_audit(p)
print(report)
}
