% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_plot.R
\name{polar_plot.cglmm}
\alias{polar_plot.cglmm}
\title{Generates a polar plot with elliptical confidence intervals}
\usage{
\method{polar_plot}{cglmm}(
  x,
  ci_level = 0.95,
  n_breaks = 5,
  component_index = NULL,
  grid_angle_segments = 8,
  radial_units = c("radians", "degrees", "period"),
  clockwise = FALSE,
  text_size = 3.5,
  text_opacity = 1,
  fill_colors,
  ellipse_opacity = 0.3,
  circle_linetype = "dotted",
  start = c("right", "left", "top", "bottom"),
  view = c("full", "zoom", "zoom_origin"),
  overlay_parameter_info = FALSE,
  quietly = TRUE,
  show_component_labels = TRUE,
  xlims,
  ylims,
  ...
)
}
\arguments{
\item{x}{An object of class \code{cglmm}}

\item{ci_level}{The level for calculated confidence ellipses.
Defaults to 0.95.}

\item{n_breaks}{The number of concentric circles that will be plotted using
the \code{scales::breaks_pretty()} function. By default, 5 breaks will be
used. The number of breaks may be adjusted to result in an even interval.
For example, if n_breaks is 3, but the maximum plot radius is 8, instead of
plotting circles in intervals in 1.6, this interval will be rounded to 2
to result in the sequence: 0, 2, 4, 6, 8. See \code{?scales::breaks_pretty}
for more details.}

\item{component_index}{A number that corresponds to a particular component
from the \code{cglmm()} object that will be used to create polar plot.
If missing (default), then plots for all components will be arranged in the
returned plot. If a single or multiple values are provided, then these
components will be returned. (for example \code{component_index = 1},
\code{component_index = c(1, 3)}).}

\item{grid_angle_segments}{An \code{integer}. Determines the total number of
segments in the background of the polar plot. For example, a value of 4 will
create quadrants around the origin. Defaults to 8.}

\item{radial_units}{A \code{character} specifying the angular units of the
plot. Possible values are one of \code{c('radians', 'degrees', 'period')}.
These units relate to the period of the component being visualized.
\describe{
\item{\code{'radians'}: \eqn{[0, 2\pi]}}{}
\item{\code{'degrees'}: \eqn{[0, 360]}}{}
\item{\code{'period'}: \eqn{[0, period]}}{}
}}

\item{clockwise}{A \code{logical}. If \code{TRUE}, the angles increase in a
clockwise fashion. If \code{FALSE}, anti-clockwise. Defaults to \code{FALSE}.}

\item{text_size}{A number controlling the font size of the text labels.
Defaults to 3.}

\item{text_opacity}{A \code{numeric} between 0 and 1 inclusive that
controls the opacity of the text labels.}

\item{fill_colors}{A \code{character} vector containing colors that will
be mapped to levels within a group. If the model has components with
different number of levels per factor, the length of this input should match
the greatest number of levels. If not, or if the number of levels exceeds the
length of the default argument (8), colors are generated using
\code{rainbow()}.}

\item{ellipse_opacity}{A \code{numeric} between 0 and 1 inclusive that
controls the opacity of the confidence ellipses. Defaults to 0.3.}

\item{circle_linetype}{A \code{character} or \code{numeric} that determines
the \code{linetype} of the radial circles in background of the polar plot.
See \code{?linetype}
for more details.}

\item{start}{A \code{character}, within
\code{c("right", "left", "top", "bottom")} that determines where angle 0 is
located. If \code{start = "top"}, and \code{clockwise = TRUE}, the angle
will rotate clockwise, starting at the '12 o-clock' position on a clock.}

\item{view}{A \code{character}, within
\code{c("full", "zoom", "zoom_origin")} that controls the view of the plots.
\describe{
\item{\code{'full'}: maintains a full view of the polar plot, including
the background radial circles.}{}
\item{\code{'zoom'}: finds the minimum view window which contains all
confidence ellipses.}{}
\item{\code{'zoom_origin'}: zooms into the confidence ellipses (like
"zoom"), but also keeps the origin within frame.}{}
}}

\item{overlay_parameter_info}{A \code{logical} argument. If \code{TRUE},
more information about the acrophase and amplitude are displayed on the
polar plots.}

\item{quietly}{Analogous to verbose, this \code{logical} argument controls
whether messages are displayed in the console.}

\item{show_component_labels}{Logical argument, TRUE by default. When TRUE,
the polar plots have labels corresponding to their components.}

\item{xlims}{A vector of length two containing the limits for the x-axis.}

\item{ylims}{A vector of length two containing the limits for the y-axis.}

\item{...}{Additional, ignored arguments.}
}
\value{
Returns a \code{ggplot} object.
}
\description{
Generates a polar plot with elliptical confidence intervals
}
\examples{
model <- cglmm(
  vit_d ~ X + amp_acro(time, group = "X", period = 12),
  data = vitamind
)
polar_plot(model, radial_units = "period")
}
