#' Data on Mexico from the Mexican Family Life Survey
#'
#' Data for the Mexico example used in chapter 7
#'
#' @format A data frame with 644 rows and 11 variables:
#' \describe{
#'   \item{SUBJECT}{Subject ID}
#'   \item{HOUSEHOLD}{Household ID}
#'   \item{STATE}{State indicator, here 5 for the state of Coahuila}
#'   \item{MIGR}{Dummy variable indicating whether respondents have thought of migrating}
#'   \item{NCRIME}{Number of crimes of which the female respondent has been the victim}
#'   \item{SEV}{Mean seriousness of the crime}
#'   \item{PAST}{Evaluations of past life conditions}
#'   \item{FUT}{Evaluations of future community conditions}
#'   \item{INC}{Respondents' income}
#'   \item{AGE}{Respondents' age}
#'   \item{WAVE}{Indicator for the wave under analysis}
#'   ...
#' }
#'
#' @usage data(mexico)
#' @examples
#' data(mexico)
#' attach(mexico)
#'
#' ## Table 7.3
#' library(lme4)
#' cs <- function(x) scale(x,scale=TRUE,center=TRUE) # Function to re-scale
#' mexico.out <- glmer(MIGR ~ cs(NCRIME) + cs(SEV) + cs(PAST) +
#'                 cs(FUT) +cs(INC) + cs(AGE) + WAVE
#'               + (1|SUBJECT), data=mexico, family=binomial("logit"),
#'               glmerControl(optimizer="bobyqa", tolPwrss=5e-2, optCtrl = list(maxfun=10000)))
#' summary(mexico.out)
#' se <- sqrt(diag(vcov(mexico.out)))
#' (cis.mexico.out <- cbind(Est = fixef(mexico.out),
#'                         LL = fixef(mexico.out) - 1.96 * se,
#'                         UL = fixef(mexico.out) + 1.96 * se))
"mexico"
