\name{runGMM}
\alias{runGMM}
\title{Run Gaussian Mixture Model (GMM) Clustering with Multiple Initialization Strategies}
\description{
Applies the Gaussian Mixture Model (GMM) to a dataset using multiple initialization strategies.
It runs the Expectation-Maximization (EM) algorithm for each initialization method and returns results for all methods.
}
\usage{
runGMM(x, k, max_iter = 100,
    run_number = 10, smax_iter = 3, 
       s_iter = 10, c_iter = 10, tol = 1e-6, burn_in = 3,verbose = FALSE)
}
\arguments{
  \item{x}{A numeric matrix or data frame where rows represent observations and columns represent variables.}
  \item{k}{An integer specifying the number of clusters.}
  \item{max_iter}{maximum iteration for running long EM}
  \item{run_number}{number of short em for emEM and emAEM initialization methods(default is 10).}
  \item{smax_iter}{An integer specifying the maximum number of iterations for short EM (default is 3).}
  \item{s_iter}{An integer specifying the number of iterations for the Stochastic Expectation-Maximization (SEM) algorithm (default is 10).}
  \item{c_iter}{An integer specifying the number of iterations for the Classification Expectation-Maximization (CEM) algorithm (default is 10).}
  \item{tol}{A numeric value specifying the convergence tolerance threshold (default is \code{1e-6}).}
  \item{burn_in}{An integer specifying the number of burn-in iterations for stochastic methods (default is 3).}
  \item{verbose}{Logical; if TRUE, prints progress messages.}
}
\value{
A named list where each element corresponds to an initialization method and contains the results of the EM algorithm:

\itemize{
  \item \code{"Random"}: Results using random initialization.
  \item \code{"hierarchical.average"}: Results using hierarchical clustering (average linkage).
  \item \code{"hierarchical.ward"}: Results using hierarchical clustering (Ward’s method).
  \item \code{"kmeans"}: Results using K-means clustering initialization.
  \item \code{"emEM"}: Results using multi-start Expectation-Maximization (EM).
  \item \code{"emAEM"}: Results using the alternative EM initialization method.
  \item \code{"sem"}: Results using the Stochastic Expectation-Maximization (SEM).
  \item \code{"cem"}: Results using the Classification Expectation-Maximization (CEM).
  \item \code{"mclust"}: Results using model-based clustering from the \pkg{mclust} package.
}

Each element in the returned list contains:
  \itemize{
    \item \code{BIC}: The Bayesian Information Criterion (BIC) value for model selection.
    \item \code{param}: A list with the estimated GMM parameters:
      \itemize{
        \item \code{pi_k}: Updated mixing proportions.
        \item \code{mu}: Updated cluster means.
        \item \code{sigma}: Updated covariance matrices.
      }
    \item \code{cluster_assignments}: Cluster labels assigned to each observation.
    \item \code{Z}: Posterior probability matrix of cluster memberships.
  }

If an initialization method fails, the corresponding list element will contain an error message.
}
\details{
The \code{runGMM} applies multiple initialization strategies for fitting a Gaussian Mixture Model (GMM) using the Expectation-Maximization (EM) algorithm.
Each initialization method is evaluated separately, and the results are returned for all tested methods.


}
\seealso{
\code{\link{runEM}}, \code{\link{getInit}}

}
\examples{
# Generate sample data
set.seed(123)
data <- matrix(rnorm(100 * 2), ncol = 2)

# Run GMM clustering with different initialization strategies
results <- runGMM(data, k = 2)
results

}

\keyword{GMM}
\keyword{clustering}
\keyword{EM}
