% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpcmStruct.R
\docType{class}
\name{gpcm-class}
\alias{gpcm-class}
\title{Gaussian Process Classification (GPC) models class}
\description{
S4 class for GPC models.
}
\section{Slots}{

\describe{
\item{\code{d}}{Object of class \code{"integer"}. The spatial dimension.}

\item{\code{n}}{Object of class \code{"integer"}. The number of observations.}

\item{\code{X}}{Object of class \code{"matrix"}. The design of experiments.}

\item{\code{y}}{Object of class \code{"matrix"}. The vector of binary observations at design points (+/-1) corresponding to the class labels.}

\item{\code{X.std}}{Object of class \code{"numeric"}. The vector of standard deviation values of design points.}

\item{\code{X.mean}}{Object of class \code{"numeric"}. The vector of mean values of design points.}

\item{\code{call}}{Object of class \code{"language"}. User call reminder.}

\item{\code{coef.m}}{Object of class \code{"numeric"}. Mean coefficient of latent GP.}

\item{\code{coef.cov}}{Object of class \code{"numeric"}. Covariance coefficients of latent GP.}

\item{\code{covariance}}{Object of class \code{"covKernel"}. A DiceKriging object specifying the covariance structure.}

\item{\code{noise.flag}}{Object of class \code{"logical"}. Are the observations noisy?}

\item{\code{noise.var}}{Object of class \code{"numeric"}. Nugget effect.}

\item{\code{param.estim}}{Object of class \code{"logical"}. \code{TRUE} if at least one parameter is estimated, \code{FALSE} otherwise.}

\item{\code{lower}}{Object of class \code{"numeric"}. Lower bounds for covariance parameters estimation.}

\item{\code{upper}}{Object of class \code{"numeric"}. Upper bounds for covariance parameters estimation.}

\item{\code{logLik}}{Object of class \code{"numeric"}. Value of the log-Likelihood at its optimum.}

\item{\code{Z_obs}}{Object of class \code{"matrix"}. A \code{nobs} * \code{nsimu} matrix of samples of the latent process at design points.}

\item{\code{l}}{Object of class \code{"numeric"}.  Lower truncation points. Parameter to generate new \code{Z_obs}.}

\item{\code{u}}{Object of class \code{"numeric"}. Upper truncation points. Parameter to generate new \code{Z_obs}.}

\item{\code{K}}{Object of class \code{"matrix"}. Covariance matrix of design points. Parameter to generate new \code{Z_obs}}

\item{\code{invK}}{Object of class \code{"matrix"}. The inverse of the matrix \code{K} whose Cholesky decomposition was given.}

\item{\code{MeanTransform}}{object of class \code{"character"}. \code{'positive'} if coef.m is constrained to be positive by an exponential transform, \code{'negative'} if coef.m is constrained to be negative.}
}}

\section{Objects from the Class}{
 To create a \code{gpcm} object, use \code{\link{gpcm}}. See also this function for more details.
}

\seealso{
{ \code{\link{gpcm}} for more details about slots and to create a \code{gpcm} object. \code{{covStruct.create}} in \code{DiceKriging} to construct a covariance structure.}
}
\author{
Morgane MENZ, Céline HELBERT, Victor PICHENY, François BACHOC. Contributors: Naoual SERRAJI.
}
\keyword{classes}
