## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE, eval = FALSE)
options(rmarkdown.html_vignette.check_title = FALSE)

## -----------------------------------------------------------------------------
# rm(list = ls())
# 
# # simulate data
# n <- 200 # subjects
# p <- 10 # variable selection predictors
# L <- 3 # cell types
# library(GPTCM)
# set.seed(1234)
# dat <- simData(n, p, L)
# 
# # KM curve
# library(survival)
# library(survminer)
# fit.km <- survival::survfit(Surv(time, event) ~ 1, data = dat$survObj)
# ggsurv <- survminer::ggsurvplot(fit.km,
#   conf.int = TRUE,
#   xlab = "Follow-up time (year)",
#   ylab = "Survival probability (%)",
#   legend = "none",
#   risk.table = TRUE,
#   cumevents = TRUE,
#   palette = "jco",
#   risk.table.title = "Number of patients at risk",
#   tables.height = 0.1,
#   tables.theme = theme_cleantable(),
#   tables.y.text = FALSE,
#   ggtheme = theme_light()
# )
# ggsurv$plot <- ggsurv$plot +
#   theme(
#     axis.text = element_text(size = 15),
#     axis.title = element_text(size = 15, face = "bold")
#   )
# ggsurv

## ----eval=FALSE, echo=FALSE---------------------------------------------------
# png("cran_km.png", bg = "transparent", width = 1200, height = 1200, res = 200)
# ggsurv
# dev.off()

## -----------------------------------------------------------------------------
# ## run Bayesian GPTCM
# set.seed(123)
# fit <- GPTCM(dat, nIter = 1100, burnin = 100)
# 
# # draw time-dependent Brier scores
# plotBrier(dat,
#   datMCMC = fit,
#   time.star = 3,
#   xlab = "Evalutation time points",
#   ylab = "Prediction error"
# )

## ----eval=FALSE, echo=FALSE---------------------------------------------------
# png("cran_brier.png", bg = "transparent", width = 950, height = 600, res = 200)
# plotBrier(dat,
#   datMCMC = fit,
#   time.star = 3,
#   xlab = "Evalutation time points",
#   ylab = "Prediction error"
# )
# dev.off()

## -----------------------------------------------------------------------------
# # show cel-type-specific effects
# plotCoeff(dat, datMCMC = fit, estimator = "beta", bandwidth = 0.02)
# # show BVS
# plotCoeff(dat, datMCMC = fit, estimator = "gamma")

## ----eval=FALSE, echo=FALSE---------------------------------------------------
# png("cran_betas.png", bg = "transparent", width = 950, height = 600, res = 200)
# plotCoeff(dat, datMCMC = fit, estimator = "beta", bandwidth = 0.02)
# dev.off()
# png("cran_gammas.png", bg = "transparent", width = 950, height = 600, res = 200)
# plotCoeff(dat, datMCMC = fit, estimator = "gamma")
# dev.off()

## -----------------------------------------------------------------------------
# # show cel-type-specific effects
# plotCoeff(dat, datMCMC = fit, estimator = "zeta", bandwidth = 0.01)
# # show BVS
# plotCoeff(dat, datMCMC = fit, estimator = "eta")

## ----eval=FALSE, echo=FALSE---------------------------------------------------
# png("cran_zetas.png", bg = "transparent", width = 950, height = 600, res = 200)
# plotCoeff(dat, datMCMC = fit, estimator = "zeta", bandwidth = 0.01)
# dev.off()
# png("cran_etas.png", bg = "transparent", width = 950, height = 600, res = 200)
# plotCoeff(dat, datMCMC = fit, estimator = "eta")
# dev.off()

