% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_interval.R
\name{flex_interval}
\alias{flex_interval}
\title{flex_interval function}
\usage{
flex_interval(
  CI_data,
  user_ref_line = NULL,
  user_ref_color = "red",
  user_ref_linetype = "dashed",
  user_ref_visible = TRUE,
  user_point_color = "blue",
  user_point_size = 3,
  user_errorbar_color = "black",
  user_errorbar_size = 0.2,
  interactive = TRUE,
  user_theme = theme_minimal(),
  user_theme_specifications = theme(),
  user_title = "PRS with Confidence Intervals",
  user_x_label = "Individual",
  user_y_label = "Polygenic Risk Score (PRS)"
)
}
\arguments{
\item{CI_data}{Data frame containing columns: \code{IID}, \code{PRS}, \code{Variance},
\code{Lower_Limit}, and \code{Upper_Limit}.}

\item{user_ref_line}{Numeric or vector. Horizontal reference line(s) to be added.
If \code{NULL}, defaults to mean PRS. Default is \code{NULL}.}

\item{user_ref_color}{Character or vector. Color(s) of reference line(s).
Default is \code{"red"}.}

\item{user_ref_linetype}{Character or vector. Linetype(s) for reference line(s).
Default is \code{"dashed"}.}

\item{user_ref_visible}{Logical. Whether to display the reference line(s).
Default is \code{TRUE}.}

\item{user_point_color}{Character. Color of PRS points. Default is \code{"blue"}.}

\item{user_point_size}{Numeric. Size of PRS points. Default is \code{3}.}

\item{user_errorbar_color}{Character. Color of confidence interval error bars.
Default is \code{"black"}.}

\item{user_errorbar_size}{Numeric. Width of error bars. Default is \code{0.2}.}

\item{interactive}{Logical. If \code{TRUE}, returns an interactive plot using \code{plotly}.
Default is \code{TRUE}.}

\item{user_theme}{A ggplot2 theme object. Default is \code{theme_minimal()}.}

\item{user_theme_specifications}{Additional theme specifications. Default is an
empty \code{theme()} object.}

\item{user_title}{Character. Title of the plot. Default is \code{"PRS with Confidence Intervals"}.}

\item{user_x_label}{Character. X-axis label. Default is \code{"Individual"}.}

\item{user_y_label}{Character. Y-axis label. Default is \code{"Polygenic Risk Score (PRS)"}.}
}
\value{
A ggplot object (static plot) or a plotly object (interactive plot),
depending on the value of \code{interactive}.
}
\description{
This function visualizes individual polygenic risk scores (PRS) with corresponding
confidence intervals. It supports customization of reference lines, colors,
themes, and interactivity.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
set.seed(123)
example_data <- data.frame(
  IID = paste0("ID_", 1:8),
  PRS = rnorm(8, 0, 1),
  Variance = runif(8, 0.01, 0.1)
)
example_data$Lower_Limit <- example_data$PRS - 1.96 * sqrt(example_data$Variance)
example_data$Upper_Limit <- example_data$PRS + 1.96 * sqrt(example_data$Variance)
CI_data <- example_data

# Basic 
flex_interval(CI_data)

# Add custom reference lines
flex_interval(CI_data,
             user_ref_line = c(1, -1),
             user_ref_color = c("darkgreen", "darkred"),
             user_ref_linetype = c("dotted", "twodash"))

# Static plot with theme customization
flex_interval(CI_data, interactive = FALSE,
             user_theme_specifications = theme(axis.text.x = element_text(angle = 45, hjust = 1)),
             user_point_color = "magenta",
             user_errorbar_color = "darkred")

# Sorted PRS plot
ordered_data <- CI_data[order(-CI_data$PRS),]
ordered_data$IID <- factor(ordered_data$IID, levels = ordered_data$IID)
flex_interval(ordered_data, interactive = FALSE, user_ref_visible = FALSE)
}
