% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subSysD.R
\name{subSysD}
\alias{subSysD}
\title{subSysD : Sub-systems Disentangling}
\usage{
subSysD(inK, inXnote = NULL)
}
\arguments{
\item{inK}{A list of models, each provided as a matrix.
A single matrix can also be provided, it will be transformed
into a list containing a single matrix.}

\item{inXnote}{A vector with the names of the input
variables. If not provided, default notation
is used: "X1", "X2", etc.}
}
\value{
subS A matrix with the extracted subsystem
}
\description{
Detect, disentangle and reformulate Sub-systems
from an ensemble of equations.
}
\examples{
# Load models
data("allMod_nVar3_dMax2")
# Display equations of system 1
visuEq(nVar = 3, dMax = 2, K = allMod_nVar3_dMax2$NH86, substit = 1)
# Display equations of system 2
visuEq(nVar = 3, dMax = 2, K = allMod_nVar3_dMax2$R76, substit = 1)
# put the two systems in a list
allK <- list()
allK[[1]] <- allMod_nVar3_dMax2$NH86
allK[[2]] <- allMod_nVar3_dMax2$R76

# Example 1 (two independant subsystems)
# take two separate systems and mix them
inXnote = list()
inXnote[[1]] <- c('u', 'v', 'w')
inXnote[[2]] <- c('X', 'Y', 'Z')
visuEq(K = allK[[1]], substit = inXnote[[1]])
visuEq(K = allK[[2]], substit = inXnote[[2]])
XnoteOut = c('u', 'X', 'v', 'Y', 'w', 'Z')
Knew3 <- combiEq(allK,dMaxOut = 3, eqOrder = c(1,4,2,5,3,6))
visuEq(K = Knew3, substit = XnoteOut)
# Disentangle the subsystems from the mixed equations
dstgl <- subSysD(Knew3, inXnote = XnoteOut)
## Optional
# library(igraph)
# g1<-graph.adjacency(dstgl$FM);
# l <- layout_with_fr(g1)
# plot(g1, edge.arrow.siez = .4, edge.curved=.4, vertex.label=XnoteOut, layout = l)

# Example 2 (one subsystem included in the other)
Kduff <- matrix(0, ncol = 4, nrow = 35)
Kduff[11,1] <- Kduff[5,2] <- Kduff[2,3] <- 1
Kduff[35,2] <- -1
Kduff[11,2] <- -0.05
Kduff[5,4] <- 2 * acos(-1) / 6.2
Xnote <- c("x", "y", "u", "v")
visuEq(Kduff, substit = Xnote)
dstgl2 <- subSysD(Kduff, inXnote = Xnote)

}
\seealso{
\code{\link{gPoMo}}, \code{\link{poLabs}}, \code{\link{combiEq}}
}
\author{
Sylvain Mangiarotti
}
