% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAPE_Basic_Functions.R
\name{makeBinaryTemplateAndProbabilityTemplate}
\alias{makeBinaryTemplateAndProbabilityTemplate}
\title{Make binary template and probability template}
\usage{
makeBinaryTemplateAndProbabilityTemplate(submat)
}
\arguments{
\item{submat}{A matrix where columns are samples and rows are pathway genes}
}
\value{
List containing binary template vector and probability template vector
}
\description{
Takes in matrix, where columns are samples and rows are pathway genes, outputs the binary and probability templates
}
\examples{
submat <- cbind(c(1,3,2,1.5),c(2,3,1.5,1.2),c(1.4,4.2,3.5,3.8))
rownames(submat) <- c("gene_A","gene_B","gene_C","gene_D")
temp <- makeBinaryTemplateAndProbabilityTemplate(submat)
bt <- temp$binary_template; pt <- temp$probability_template
cbind(bt,pt)
}
