% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_color_grid.R
\name{image_color_grid}
\alias{image_color_grid}
\title{Draws the density of a grid copula with colors}
\usage{
image_color_grid(gc, color.name = "heat.colors", color.size = 7)
}
\arguments{
\item{gc}{a grid type copula object.}

\item{color.name}{indicates the palette of colors.}

\item{color.size}{indicates the number of colors.}
}
\value{
Returns a graph of the density.
}
\description{
Draws the density of a grid copula with colors
}
\examples{
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
k <- 10
m <- 10
copula.grid <- estimate.gridCopula(U = df, k = k, m = m , method = "ml")
image_color_grid(gc = copula.grid, color.name = "rainbow", color.size = 10)

#Iris
copula.grid <- estimate.gridCopula(X = iris[,1:2], k = k, m = m , method = "ml")
image_color_grid(gc = copula.grid, color.name = "rainbow", color.size = 10)
}
