% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alex.prep.lsn.expr.R
\name{alex.prep.lsn.expr}
\alias{alex.prep.lsn.expr}
\title{Prepare Lesion and Expression Data for Kruskal Wallis Test}
\usage{
alex.prep.lsn.expr(
  expr.mtx,
  lsn.data,
  gene.annotation,
  min.expr = NULL,
  min.pts.lsn = NULL
)
}
\arguments{
\item{expr.mtx}{A data frame or matrix of normalized, log2-transformed gene expression values with genes in rows and subjects in columns. The first column must be named \code{"ensembl.ID"} and contain Ensembl gene IDs.}

\item{lsn.data}{A data frame of lesion data in GRIN-compatible format. Must contain five columns:
\code{"ID"} (patient ID), \code{"chrom"} (chromosome), \code{"loc.start"} (lesion start position), \code{"loc.end"} (lesion end position), and \code{"lsn.type"} (lesion type; e.g., gain, loss, mutation, fusion, etc..).}

\item{gene.annotation}{A gene annotation data frame, either user-provided or retrieved via \code{get.ensembl.annotation()} from the GRIN2.0 package. Must contain four columns: \code{"gene"} (Ensembl gene ID), \code{"chrom"} (chromosome), \code{"loc.start"} (gene start), and \code{"loc.end"} (gene end).}

\item{min.expr}{Minimum total expression level required for a gene to be retained (i.e., sum of expression values across all subjects). Useful to filter out genes with very low expression.}

\item{min.pts.lsn}{Minimum number of subjects required to have a lesion in a gene for that gene to be retained for the KW test.}
}
\value{
A list with the following components:
\item{alex.expr}{A matrix of gene expression data with Ensembl gene IDs as row names and patient IDs as column names.}
\item{alex.lsn}{A matrix of lesion data for the same genes and patients as in \code{alex.expr}, similarly ordered.}
\item{alex.row.mtch}{A data frame with two columns showing the matched Ensembl gene IDs from the expression and lesion matrices.}
}
\description{
Prepares matched lesion and expression data matrices for use with the \code{KW.hit.express} function, which performs Kruskal Wallis tests to assess associations between lesion groups and gene expression levels.
}
\details{
The function uses \code{prep.lsn.type.matrix()} internally to create a lesion matrix where each gene is represented by one row and all lesion types are included. It filters genes to retain only those with both sufficient expression and lesion data. The final expression and lesion matrices are matched by gene and patient IDs, with rows ordered by Ensembl gene ID and columns by patient ID.
}
\examples{
data(expr_data)
data(lesion_data)
data(hg38_gene_annotation)

# Prepare matched lesion and expression data
alex.data <- alex.prep.lsn.expr(expr_data, lesion_data,
                                hg38_gene_annotation, min.expr = 1,
                                min.pts.lsn = 5)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{KW.hit.express}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
