% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSAtool.R
\name{GSAtool}
\alias{GSAtool}
\title{Global Sensitivity Analysis tool}
\usage{
GSAtool(
  parameters_set,
  out_set,
  pp_names,
  steps = 100,
  save = FALSE,
  dir = NULL
)
}
\arguments{
\item{parameters_set}{matrix of dimensions n x pp, where n is the
number of runs and pp is the number of parameters.}

\item{out_set}{matrix of dimensions n x t, where n is the number of
runs and t is the number of temporary steps.}

\item{pp_names}{a strings vector with the names of the parameters of the model}

\item{steps}{number of divisions of the parametric range.}

\item{save}{T to save the results in .csv files, by default save=F.}

\item{dir}{a directory  to save the results}
}
\value{
a list containing two outputs: SOBOL and AMA indices.
}
\description{
This function performs the global sensitivity analysis starting from the gross results of the model.
}
\examples{
data("parameters_set", "out_set", "pp_names")
\donttest{

GSA_results <- GSAtool(parameters_set, out_set, pp_names, steps = 15, save=FALSE)
}
}
\references{
Dell’Oca, A., Riva, M., & Guadagnini, A. (2017). Moment-based metrics for global sensitivity
analysis of hydrological systems. Hydrology and Earth System Sciences, 21(12), 6219–6234.
 https://doi.org/10.5194/hess-21-6219-2017

Sobol, I. M. (2001). Global sensitivity indices for nonlinear mathematical models
and their Monte Carlo estimates. Mathematics and Computers in Simulation, 55(1–3),
271–280. https://doi.org/10.1016/S0378-4754(00)00270-6
}
\author{
Camila Garcia-Echeverri <cagarciae@unal.edu.co> \cr
Maria Cristina Areas-Bautista <mcarenasb@unal.edu.co> \cr


Hydrodynamics of the natural media research group - HYDS
National University of Colombia -  Bogota
}
