% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_manipulation.R
\name{add_mapping_info}
\alias{add_mapping_info}
\title{Add Mapping Information to GTAP Data}
\usage{
add_mapping_info(
  data_list,
  external_map = NULL,
  mapping = "GTAPv7",
  description_info = TRUE,
  unit_info = TRUE
)
}
\arguments{
\item{data_list}{A list or nested data structure containing GTAP output data frames.}

\item{external_map}{Optional data frame. External mapping must include columns: \code{"Variable"}, \code{"Description"}, and \code{"Unit"}.}

\item{mapping}{Character. Mapping mode for assigning metadata to variables.
Options:
\itemize{
\item \code{"GTAPv7"}: Use GTAPv7 internal definitions (default).
\item \code{"Yes"}: Use only the provided \code{external_map}.
\item \code{"Mix"}: Use external definitions first, then fallback to GTAPv7 for missing values.
\item \code{"No"}: Skip mapping entirely.
}}

\item{description_info}{Logical. If \code{TRUE}, adds or updates variable descriptions. Default: \code{TRUE}.}

\item{unit_info}{Logical. If \code{TRUE}, adds or updates unit information. Default: \code{TRUE}.}
}
\value{
The same data structure as input with added \code{"Description"} and \code{"Unit"} columns, if applicable.
}
\description{
Adds descriptions and unit information to GTAP data based on a specified mapping mode.
Supports external mappings or default GTAPv7 mappings, allowing users to enrich datasets with
standardized metadata.

Adds \strong{description} and \strong{unit} information to GTAP data structures based on a specified mapping mode.
This function supports internal GTAPv7 mappings, external mappings, or a combination of both.
}
\details{
The \code{mapping} argument supports:
}
\examples{
# Load GTAP SL4 data
input_path <- system.file("extdata/in", package = "GTAPViz")
sl4.plot.data <- readRDS(file.path(input_path, "sl4.plot.data.rds"))

# Add mapping using GTAPv7 defaults
gtap_data <- add_mapping_info(sl4.plot.data, mapping = "GTAPv7")

# Use a custom mapping file
my_map <- data.frame(
  Variable = c("qgdp", "EV"),
  Description = c("Real GDP", "Welfare"),
  Unit = c("percent", "million USD")
)
gtap_data <- add_mapping_info(sl4.plot.data, external_map = my_map, mapping = "Mix")

}
\seealso{
\code{\link{convert_units}}, \code{\link{rename_value}}
}
\author{
Pattawee Puangchit
}
