% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GTE.R
\name{Run.GroupTechEffects}
\alias{Run.GroupTechEffects}
\title{Compute the group technical effects.}
\usage{
Run.GroupTechEffects(X, meta, g_factor, b_factor, do.scale = FALSE)
}
\arguments{
\item{X}{Input data matrix.}

\item{meta}{Input metadata (data.frame).}

\item{g_factor}{Group variable (s).}

\item{b_factor}{Batch variable (s).}

\item{do.scale}{Whether to perform scaling.}
}
\value{
A list containing the overall GTE ($OverallTechEffects) and the GTE ($GroupTechEffects) of each subgroup under the group variable.
}
\description{
Compute the group technical effects.
}
\examples{
# X is a normalized expression matrix with rows as features and columns as cells.

# meta is a data.frame with columns containing metadata such as cell type, batch, etc.

data_file <- system.file("extdata", "example_data.rds", package = "GTEs")
example_data <- readRDS(data_file)
meta_file <- system.file("extdata", "example_meta.rds", package = "GTEs")
example_meta <- readRDS(meta_file)
GTE_ct <- Run.GroupTechEffects(example_data, example_meta,
                               g_factor = "CellType",
                               b_factor = "Batch")
}
