% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IM_dep.R
\name{IM_dep}
\alias{IM_dep}
\title{IM_dep Function: Calculate Influence Measure with Dependent Features}
\usage{
IM_dep(Xdata, Ydata, index)
}
\arguments{
\item{Xdata}{Matrix. A dataset where rows represent observations and columns represent features.}

\item{Ydata}{Vector. The response variable associated with each row in \code{Xdata}.}

\item{index}{Vector. A grouping vector that assigns each feature in \code{Xdata} to a specific union. E.g., if we
have the partition set P=\{\{1\},\{2,4\},\{3\}\}, then index=c(1,2,3,2).}
}
\value{
A vector of influences for each feature.
}
\description{
The \code{IM_dep} function calculates the influence measure of equation (2) in Davila-Pena et al. (2024).
The features are grouped into unions based on the \code{index} vector.
}
\details{
The \code{IM_dep} function calculates the weighted average of the number of times a change in
the value of a feature associated to a specific union influences the response value.
}
\examples{
# Example usage from Example 5.2 in Davila-Pena et al. (2024):

library(CoopGame)
n.user <- 16
Xdata <- createBitMatrix(4)[,-5]
Xdata <- rbind(c(0,0,0,0),Xdata)
Ydata <- rep(0,n.user)
Ydata[1+c(10,11,13,14,15)] <- 1

# Scenario 1:
IM_dep(Xdata,Ydata,index = c(1,2,3,4))
# Scenario 9:
IM_dep(Xdata,Ydata,index = c(1,2,1,2))

}
\references{
Davila-Pena, L., Saavedra-Nieves, A., & Casas-Méndez, B. (2024). \emph{On the influence of dependent features in classification problems: a game-theoretic perspective}. arXiv preprint. \doi{10.48550/arXiv.2408.02481}.
}
