% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diB.R
\name{dib.fun}
\alias{dib.fun}
\title{Function for DIb}
\usage{
dib.fun(X, N)
}
\arguments{
\item{X}{A count random variable}

\item{N}{The number of trials of binomial distribution}
}
\value{
Returns
\item{dib}{The binomial dispersion index}
}
\description{
The function computes the binomial dispersion index for a given number of trials \eqn{N\in \{1,2,\ldots\}}.
}
\details{
\code{dib.fun} computes the dispersion index with respect to the binomial distribution. See Touré et al. (2020) and Weiss (2018) for more details.
}
\examples{
X<-c(12,9,0,8,5,7,6,5,3,4,9,4)
dib.fun(X,12)
Y<-c(0,0,1,1,0,1,1)
dib.fun(Y,7)
}
\references{
Touré, A.Y., Dossou-Gbété, S. and Kokonendji, C.C. (2020). Asymptotic normality of the test statistics for relative dispersion and relative variation indexes, \emph{Journal of Applied Statistics} \bold{47}, 2479-2491.\cr
\cr
Weiss, C.H. (2018). An Introduction to Discrete-Valued Times Series. \emph{Wiley}, Hoboken NJ.
}
\author{
Aboubacar Y. Touré and Célestin C. Kokonendji
}
