% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwl_fit.R
\name{gwl_fit}
\alias{gwl_fit}
\title{Fit a geographically weighted lasso with the selected bandwidth}
\usage{
gwl_fit(
  bw,
  x.var,
  y.var,
  kernel,
  dist.mat,
  alpha,
  adaptive,
  progress = TRUE,
  nfolds = 5
)
}
\arguments{
\item{bw}{Bandwidth}

\item{x.var}{input matrix, of dimension nobs x nvars; each row is an observation vector. x should have 2 or more columns.}

\item{y.var}{response variable for the lasso}

\item{kernel}{the geographical kernel shape to compute the weight. passed to \code{\link[GWmodel:gw.weight]{GWmodel::gw.weight()}}
Can be \code{gaussian}, \code{exponential}, \code{bisquare}, \code{tricube}, \code{boxcar}}

\item{dist.mat}{a distance matrix. can be generated by \code{\link[=compute_distance_matrix]{compute_distance_matrix()}}}

\item{alpha}{the elasticnet mixing parameter. set 1 for lasso, 0 for ridge. see \code{\link[glmnet:glmnet]{glmnet::glmnet()}}}

\item{adaptive}{TRUE or FALSE Whether to perform an adaptive bandwidth search or not. A fixed bandwidth means that samples are selected if they fit a determined fixed radius around a location.
In a adaptive bandwidth, the radius around a location varies to gather a fixed number of samples around the investigated location}

\item{progress}{TRUE/FALSE whether to display a progress bar or not}

\item{nfolds}{the number f folds for the glmnet cross validation}
}
\value{
a \code{gwlfit} object containing a fitted Geographically weighted Lasso.
}
\description{
Fit a geographically weighted lasso with the selected bandwidth
}
\examples{

predictors <- matrix(data = rnorm(2500), 50,50)
y_value <- sample(1:1000, 50)
coords <- data.frame("Lat" = rnorm(50), "Long" = rnorm(50))
distance_matrix <- compute_distance_matrix(coords)

my.gwl.fit <- gwl_fit(bw = 20,
                      x.var = predictors, 
                      y.var = y_value,
                      kernel = "bisquare",
                      dist.mat = distance_matrix, 
                      alpha = 1, 
                      adaptive = TRUE, 
                      progress = TRUE,
                      nfolds = 5)

my.gwl.fit


}
