% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_list_tools}
\alias{galaxy_list_tools}
\title{List tools installed on a Galaxy instance}
\usage{
galaxy_list_tools(
  galaxy_url = "https://usegalaxy.eu",
  in_panel = FALSE,
  panel_id = NULL
)
}
\arguments{
\item{galaxy_url}{Character. Base URL of the Galaxy instance
(for example \code{"https://usegalaxy.eu"}).
If the environment variable \code{GALAXY_URL} is set, it takes precedence.}

\item{in_panel}{Logical. If \code{TRUE}, return the tool panel
structure (sections/categories). If \code{FALSE}, return the flat
list of all tools as supplied by Galaxy. Default: \code{FALSE}.}

\item{panel_id}{Optional character. When supplied, only tools from the
matching panel (section/category) are returned. The value is matched
against both the panel \code{id} and \code{name}. Supplying
\code{panel_id} automatically requests the panelized structure,
regardless of the value of \code{in_panel}.}
}
\value{
A list corresponding to the parsed JSON returned by Galaxy.
If \code{panel_id} is provided, a list of tool entries belonging to
the requested panel is returned (each entry is the raw tool metadata
as provided by Galaxy).
}
\description{
List tools installed on a Galaxy instance
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
# All tools (flat list)
tools_list <- galaxy_list_tools()
length(tools_list)

# Panel structure
panel_list <- galaxy_list_tools(in_panel = TRUE)
length(panel_list)

# Tools from a specific panel (match by id or name)
tools_list <- galaxy_list_tools(panel_id = "Get Data")
length(tools_list)
\dontshow{\}) # examplesIf}
}
