\name{genseq}
\alias{genseq}
\title{
Color tag combination generator
}
\description{
Create sequences of color tags for animal identification.
}
\usage{
genseq(ncombinations = 100, ntag = 4, colorsname, gen_method = "allequal", 
usedcombinations = NA, colorsf = NA, nspecial = 0, name1 = "Metal", name2 = "EMPTY", 
location1 = 1, location2 = 2, nspecial1 = 1, nspecial2 = 1, emptyused = FALSE, 
emptyname = "EMPTY", currentyear = NA, yearsurvival = 1, lifespan = NA, iotf = FALSE, 
yearusedcombinations = NA, speed = 1, ignorecolor = NA, 
g1 = NA, g2 = NA, g3 = NA, g4 = NA, g5 = NA, g6 = NA, parameterslist = NA)


}
\arguments{
  \item{ncombinations}{
Number of combinations to be generated.
}
  \item{ntag}{
Number of tag to be used in each animal.
}
  \item{colorsname}{
Names/Code of color tags to be sample.
}
  \item{gen_method}{
method used for sample colors for tag sequence.
}
  \item{usedcombinations}{
Pre used combinations.
}
  \item{colorsf}{
Frequencies/ratio for color sample.
}
  \item{nspecial}{
Number of special tags/codes, such as metallic, "EMPTY", or flag (min 0, max 2).
}
  \item{name1}{
Name of special tag 1.
}
  \item{name2}{
Name of special tag 2.
}
  \item{location1}{
Position (or group of positions) to special band 1.
}
  \item{location2}{
Position (or group of positions) to special band 2.
}
  \item{nspecial1}{
Number of special tag 1 that will be present in all sequences genetated.
}
  \item{nspecial2}{
Number of special tag 2 that will be present in all sequences genetated.
}
  \item{emptyused}{
If pre-used combination has code for empty set as TRUE, otherwise FALSE
}
  \item{emptyname}{
Code used to define empty code.
}
  \item{currentyear}{
Current year.
}
  \item{yearsurvival}{
An estimation of the proportion of animals that survive between years.
}
  \item{lifespan}{
Combinations older the lifespan will be automatically disregard.
}
  \item{iotf}{
Ignore older than lifespan. If TRUE ignore pre-used combinations older than lifespan
}
  \item{yearusedcombinations}{
The year in which the combination was used.
}
  \item{speed}{
Speed for color frequency adjustment.
}
  \item{ignorecolor}{
Color to be ignored on lifexp.
}
  \item{g1}{
Group of tags from group 1. For example, in a code of 6 colors for bird tag, tags from 1 to 3 belongs to the left leg, and  tags from 1 to 3 belongs to the right. g1 must to address the left leg, and g2 must to address right leg. Thus: "g1=1:3" and "g2=4:6".
}
  \item{g2}{
Group of tags from group 2. For example, in a code of 6 colors for bird tag, tags from 1 to 3 belongs to the left leg, and  tags from 1 to 3 belongs to the right. g1 must to address the left leg, and g2 must to address right leg. Thus: "g1=1:3" and "g2=4:6".
}
  \item{g3}{
Group of tags from group 3.
}
  \item{g4}{
Group of tags from group 4.
}
  \item{g5}{
Group of tags from group 5.
}
  \item{g6}{
Group of tags from group 6.
}
  \item{parameterslist}{
parameters for methods not provide by 'GenTag'
}
}
\value{
A list of combinations
}

\author{
Biagolini-Jr.
}

\seealso{
allequal
vfrequency
lifexp
}
\examples{
# Create an object contain the name/code of tag colors 
tcol<-c("Black","Blue","Brown","Gray","Green","Pink","Purple","Red","White","Yellow")
# Generate color tag combination without especial tags
genseq(30, 4, colorsname= tcol) 
#Generate color tag combination with especial color (ex metallic tag for numeric identification)
genseq(30, 4, tcol, nspecial=1, name1="Metal", location1=c(2,4)) 
# For ongoing works, use the argument usedcombinations to informe the previus used combinations
data(pre_used) # Data example
genseq(30, 4, colorsname= tcol, usedcombinations=pre_used[,1:4]) 
combinations<-genseq(100, 4, tcol) # save combinations into an object
}