\name{lifexp}
\alias{lifexp}
\title{
Life expectancy tag sequence sample
}
\description{
Create combinations with variable sample probability.
}
\usage{
lifexp(ntag, colorsname, nspecial = 0, name1 = "Metal", name2 = "EMPTY", 
location1 = 1, location2 = 2, nspecial1 = 1, nspecial2 = 1, currentyear = NA,
 yearsurvival = 1, lifespan = NA, yearusedcombinations, 
usedcombinations, speed = 1, ignorecolor = NA)

}
\arguments{
  \item{ntag}{
Number of tag to be used in each animal.
}
  \item{colorsname}{
Names/Code of color tags to be sample.
}
  \item{nspecial}{
Number of special tags/codes, such as metallic, "EMPTY", or flag (min 0, max 2).
}
  \item{name1}{
Name of special tag 1.
}
  \item{name2}{
Name of special tag 2.
}
  \item{location1}{
Position (or group of positions) to special band 1.

}
  \item{location2}{
Position (or group of positions) to special band 2.
}
  \item{nspecial1}{
Number of special tag 1 that will be present in all sequences genetated.
}
  \item{nspecial2}{
Number of special tag 2 that will be present in all sequences genetated.
}
  \item{currentyear}{
Current year.
}
  \item{yearsurvival}{
An estimation of the proportion of animals that survive between years.
}
  \item{lifespan}{
Combinations older the lifespan will be automatically disregard.
}
  \item{yearusedcombinations}{
The year in which the combination was used.
}
  \item{usedcombinations}{
Pre used combinations.
}
  \item{speed}{
Speed for color frequency adjustment.
}
  \item{ignorecolor}{
Color to be ignored on lifexp.
}
}
\value{
A sequencie of tags
}
\author{
Biagolini-Jr.
}
\seealso{
allequal
genseq
vfrequency
}
\examples{
data(pre_used) # Data example
# Create an object contain the name/code of tag colors 
tcol<-c("Black","Blue","Brown","Gray","Green","Pink","Purple","Red","White","Yellow")
genseq(30, 4,tcol, "lifexp", pre_used[,1:4], 
yearusedcombinations=pre_used[,5], yearsurvival= 0.8, lifespan=5, currentyear=2019)
}
