% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomean_calculator.R
\name{geomean}
\alias{geomean}
\title{Calculate Geometric Means from Count Tables}
\usage{
geomean(count_table, na.action = c("omit", "fail"))
}
\arguments{
\item{count_table}{A data frame of gene count data (genes as rows, samples as columns). All columns must be numeric.}

\item{na.action}{Character: how to handle NAs. Options are
\itemize{
\item "omit" (default): ignore NAs and compute the geometric mean with remaining values
\item "fail": return NA for the sample if any NA is present
}}
}
\value{
A data frame with the geometric means per sample and the sample IDs.
}
\description{
This function computes the geometric mean for each sample in the given count table.
Users can choose how to handle missing values.
}
\examples{
count_table <- data.frame(
  sample1 = c(1, 10, 100),
  sample2 = c(2, 20, 200),
  sample3 = c(3, 30, NA)
)
rownames(count_table) <- c("gene1", "gene2", "gene3")

geomean(count_table)

geomean(count_table, na.action = "fail")
}
