% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glarma.R
\name{glarma}
\alias{glarma}
\title{Solve Graphical Lasso with Armadillo}
\usage{
glarma(s, rho, mtol = 1e-04, maxIterations = 10000, ltol = 1e-06)
}
\arguments{
\item{s}{A symmetric, positive-definite sample covariance matrix.
It should be a square matrix representing the covariance matrix of the variables.}

\item{rho}{A positive scalar representing the regularization parameter.
It controls the sparsity level of the inverse covariance matrix.}

\item{mtol}{A numeric value representing the convergence threshold for the main algorithm.
It determines the condition under which the iterative process will stop.
Default is 1e-4.}

\item{maxIterations}{An integer value specifying the maximum number of iterations
allowed for the algorithm. Default is 10000.}

\item{ltol}{A numeric value representing the convergence threshold for the Lasso solver.
It is used to control the Lasso solving process within the algorithm.
Default is 1e-6.}
}
\value{
Returns a covariance matrix W and a estimated sparse inverse covariance matrix Theta
estimated by solving the Graphical Lasso problem. The sparsity is controlled
by the 'rho' parameter.
}
\description{
This function solves the Graphical Lasso (GLasso) problem using the Armadillo library.
GLasso is a technique used in statistical learning and network analysis to
estimate sparse inverse covariance matrices from observed data.
}
\examples{
# Generate a sample covariance matrix
s <- matrix(runif(100), nrow = 10)
s <- t(s) \%*\% s
# Solve the Graphical Lasso problem with default parameters
inv_cov_matrix <- glarma(s, rho = 0.1)
# Solve with custom convergence thresholds and maximum iterations
inv_cov_matrix <- glarma(s, rho = 0.1, mtol = 1e-5, maxIterations = 5000, ltol = 1e-6)

}
