% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmptz.R
\name{gmptz}
\alias{gmptz}
\title{Gompetrz Curve Fitting}
\usage{
gmptz(y)
}
\arguments{
\item{y}{a numeric vector}
}
\value{
a.hat , b.hat , k.hat   :    the estimated values of the parameters a,b and k.

predicted.value  :   the predicted values of y
}
\description{
This function  fits the Gompertz Curve in Time Series Data along with estimates of the parameters and predicted value.
}
\details{
The Gompertz curve is a type of mathematical model for a Time Series. It is a sigmoid function which describes growth as being slowest at the start and end of a given time period. The equation of Gompertz curve is given by , Y=k*a^(b^x)

Taking Logarithm on both sides we get, LogY=Logk+(b^x)*Loga ; OR, Z=A+B(C^x) , where Z=LogY , A=logk , B=loga ,C=b; It is a form of Modified Exponential.So ,now we can apply Method Of Group Average.
}
\examples{
 p=c(12,15,16,18,16,21,25,27,29,30,35,36)
 gmptz(p)
}
\author{
ARNAB ROY, DEBARGHYA BAUL
}
