% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_growth_model_mixed.R
\name{summarize_growth_model_mixed}
\alias{summarize_growth_model_mixed}
\title{Summarize mixed-effects growth model object and data}
\usage{
summarize_growth_model_mixed(
  data_frame,
  mixed_growth_model,
  function_type = "exponential",
  fixed_rate = TRUE,
  time_unit = "hours"
)
}
\arguments{
\item{data_frame}{A data frame object that at minimum contains three
variables:
\itemize{
\item cluster - a character type variable used to specify how observations
are nested or grouped by a particular cluster. Note if using a
least-squares model, please fill in cluster values with a single repetitive
dummy variable (e.g., '1'), do not leave blank.
\item time - a numeric type variable used for measuring time such as
minutes, hours, or days
\item growth_metric - a numeric type variable used for measuring growth
over time such as cell count or confluency
}}

\item{mixed_growth_model}{The mixed-effects model object that is created
using the \code{\link{growth_curve_model_fit}}}

\item{function_type}{A character string specifying the function for
modeling the shape of the growth. Options include "exponential", "linear",
"logistic", or "gompertz".}

\item{fixed_rate}{A logical value specifying whether the rate constant
of the function should be treated as a fixed effect (TRUE) or random
effect (FALSE). Defaults to TRUE}

\item{time_unit}{A character string specifying the units in which time is
measured in. Defaults to "hours"}
}
\value{
A list object with the following data frames within the list:
\itemize{
\item model_summary_wide - a data frame with 1 row containing
key model estimates, doubling-time, and model metrics depending
on the model_type and function_type specified
\item model_summary_long - a data frame that is a long dataset version of
'model_summary_wide' that can be used to generate a table of the model
results (see function \code{\link{growth_model_summary_table}})
\item model_residual_data - a data frame containing the original data
frame values as well as predicted values, residuals, and theoretical
quantiles of the residuals depending on the model_type selected
(see functions \code{\link{growth_model_residual_plots}} and
\code{\link{growth_vs_time_plot}})
\item model_sim_pred_data - a data frame with estimates and 95\% prediction
intervals (not to be confused with the 95\% confidence intervals calculated
from the model estimates), for mixed-effects models, values are calculated
as the median estimate and the 2.5th and 97.5th percentiles of the
simulated data from the saemix model at each time point (see
\code{\link[saemix]{compute.sres}} and \code{\link[saemix]{plot}} with
plot.type = "vpc"). For least-squares models, prediction intervals are
calculated through Taylor-series approximations using the
\code{\link[investr]{predFit}} function.
}
}
\description{
This function is used within the \code{\link{summarize_growth_model}}
function to create a list object of
data frames based on a user's input data frame and output mixed-effects
growth model object from \code{\link{growth_curve_model_fit}}.
The list object (referred to in this package as 'growth_model_summary_list')
can be used to extract model predicted values, residuals, and can be
inputted into supporting functions from GrowthCurveME to generate plots and
perform model diagnostics.
}
\examples{
\donttest{
# Load example data (exponential data)
data(exp_mixed_data)
# Fit an mixed-effects growth model to the data
exp_mixed_model <- growth_curve_model_fit(
data_frame = exp_mixed_data,
function_type = "exponential",
return_summary = FALSE)
# Summarize the data by creating a summary list object
exp_mixed_model_summary <- summarize_growth_model_mixed(
data_frame = exp_mixed_data,
mixed_growth_model = exp_mixed_model,
fixed_rate = TRUE,
function_type = "exponential",
time_unit = "hours")
model_summary_wide <- exp_mixed_model_summary[["model_summary_wide"]]
}
}
\seealso{
\code{\link{growth_curve_model_fit}}
\code{\link{summarize_growth_model}}
}
